/*
 * Copyright (c) 2008-2017 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.wizards.newfile;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.wetator.testeditor.editors.WTEMessages;

/**
 * WTE Wizard extension to provide simple means to create new test case files.
 * 
 * @author chriseverty
 * @author frank.danek
 */
public class WetatorNewFileWizard extends Wizard implements INewWizard {

  private IStructuredSelection selection;
  private WetatorNewFileWizardPage wetatorFileWizardPage;

  /**
   * Defines the window title.
   * 
   * @see #getWindowTitle()
   */
  public WetatorNewFileWizard() {
    super();
    setWindowTitle(WTEMessages.wizardTitle);
  }

  @Override
  public void addPages() {
    wetatorFileWizardPage = new WetatorNewFileWizardPage(selection);
    addPage(wetatorFileWizardPage);
  }

  @Override
  public boolean performFinish() {
    final IFile tmpFile = wetatorFileWizardPage.createNewFile();
    if (null == tmpFile) {
      return false;
    }
    return true;
  }

  @Override
  public void init(final IWorkbench aWorkbench, final IStructuredSelection aSelection) {
    selection = aSelection;
  }
}
