/*
 * Copyright (c) 2008-2017 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xsd;

import java.util.List;

import org.wetator.scripter.XMLScripter;
import org.wetator.testeditor.editors.AbstractWTEContentList;

/**
 * The schema list presented in {@link WTEXSDTableViewer}.
 * 
 * @author tobwoerk
 * @author frank.danek
 */
public class WetatorSchemaList extends AbstractWTEContentList<WetatorXMLSchema> {

  /**
   * Default constructor.
   */
  public WetatorSchemaList() {
    this(WetatorXMLSchema.class);
  }

  private WetatorSchemaList(final Class<WetatorXMLSchema> aType) {
    super(aType);
  }

  /**
   * @param aSchemaList contains the schemas to initialize with
   */
  @Override
  public void initData(final List<WetatorXMLSchema> aSchemaList) {
    elements.clear();
    // make default schemas the first two ones
    elements.add(new WetatorXMLSchema(XMLScripter.BASE_SCHEMA));
    elements.add(new WetatorXMLSchema(XMLScripter.DEFAULT_COMMAND_SET_SCHEMA));
    for (final WetatorXMLSchema tmpSchema : aSchemaList) {
      if (!tmpSchema.isDefaultSchema()) {
        elements.add(tmpSchema);
      }
    }
  }
}