/*
 * Copyright (c) 2008-2017 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xml.scanner;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.wetator.testeditor.editors.xml.XMLColorConstants;
import org.wetator.testeditor.editors.xml.XMLColorManager;
import org.wetator.testeditor.editors.xml.XMLWhitespaceDetector;

/**
 * Scanner for XML comments.
 * 
 * @author eclipse
 * @author tobwoerk
 */
public class XMLCommentScanner extends RuleBasedScanner {

  /**
   * @param aManager the color manager
   */
  public XMLCommentScanner(final XMLColorManager aManager) {
    final IToken tmpString = new Token(new TextAttribute(aManager.getColor(XMLColorConstants.STRING)));

    final IRule[] tmpRules = new IRule[3];

    // Add rule for double quotes
    tmpRules[0] = new SingleLineRule("\"", "\"", tmpString, '\\');
    // Add a rule for single quotes
    tmpRules[1] = new SingleLineRule("'", "'", tmpString, '\\');
    // Add generic whitespace rule.
    tmpRules[2] = new WhitespaceRule(new XMLWhitespaceDetector());

    setRules(tmpRules);
  }
}
