/*
 * Copyright (c) 2008-2017 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.wte;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.EditingSupport;

/**
 * Abstract editing support for {@link WTETableViewer}.
 *
 * @author tobwoerk
 * @author frank.danek
 */
public abstract class AbstractWTEEditingSupport extends EditingSupport {

  private int index;

  /**
   * Constructor.
   *
   * @param aViewer the table viewer
   * @param anIndex the index of the column
   */
  public AbstractWTEEditingSupport(final WTETableViewer aViewer, final int anIndex) {
    super(aViewer);
    index = anIndex;
  }

  @Override
  protected CellEditor getCellEditor(final Object anElement) {
    return getViewer().getCellEditors()[index];
  }

  @Override
  protected void setValue(final Object anElement, final Object aValue) {
    final WetatorCommand tmpCommand = (WetatorCommand) anElement;
    setValue(tmpCommand, aValue);
    getViewer().refresh();
  }

  /**
   * Convenience setValue possibility for {@link WetatorCommand} elements.
   *
   * @param aCommand the command
   * @param aValue the value to set
   */
  protected abstract void setValue(WetatorCommand aCommand, Object aValue);

  @Override
  protected Object getValue(final Object anElement) {
    final WetatorCommand tmpCommand = (WetatorCommand) anElement;
    return getValue(tmpCommand);
  }

  /**
   * Convenience getValue possibility for {@link WetatorCommand} elements.
   *
   * @param aCommand the command to get value from
   * @return the value
   */
  protected abstract Object getValue(WetatorCommand aCommand);

  /**
   * {@inheritDoc}
   *
   * @see org.eclipse.jface.viewers.EditingSupport#canEdit(java.lang.Object)
   */
  @Override
  protected boolean canEdit(final Object anElement) {
    final WetatorCommand tmpCommand = (WetatorCommand) anElement;
    return canEdit(tmpCommand);
  }

  /**
   * Convenience canEdit possibility for {@link WetatorCommand} elements.
   *
   * @param aCommand the command to check
   * @return true as default
   */
  protected boolean canEdit(final WetatorCommand aCommand) {
    return true;
  }
}