/*
 * Copyright (c) 2008-2017 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.exception;

/**
 * An exception marking that a given file is not processable by the WTE.
 * 
 * @author tobwoerk
 */
public class FileNotSupportedException extends Exception {

  private static final long serialVersionUID = 2611494080643491571L;

  /**
   * Constructor containing a message.
   * 
   * @param aMessage the exception message
   */
  public FileNotSupportedException(final String aMessage) {
    super(aMessage);
  }
}
