/*
 * Copyright (c) 2008-2017 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xsd;

import org.wetator.scripter.XMLScripter;
import org.wetator.scripter.xml.XMLSchema;
import org.wetator.testeditor.editors.AbstractWTETableViewerElement;

/**
 * Wrapper for {@link XMLSchema} with complete {@link #hashCode()} and {@link #equals(Object)}.
 * 
 * @author tobwoerk
 * @author frank.danek
 */
public class WetatorXMLSchema extends AbstractWTETableViewerElement {

  private XMLSchema schema;

  /**
   * Default constructor.
   */
  public WetatorXMLSchema() {
    this("", "", "");
  }

  /**
   * Constructor.
   * 
   * @param aNamespace the namespace to set
   * @param aLocation the location to set
   */
  public WetatorXMLSchema(final String aNamespace, final String aLocation) {
    schema = new XMLSchema(aNamespace, aLocation);
  }

  /**
   * Constructor.
   * 
   * @param aPrefix the prefix to set
   * @param aNamespace the namespace to set
   * @param aLocation the location to set
   */
  public WetatorXMLSchema(final String aPrefix, final String aNamespace, final String aLocation) {
    schema = new XMLSchema(aPrefix, aNamespace, aLocation);
  }

  /**
   * Constructor.
   * 
   * @param aSchema the schema to wrap
   */
  public WetatorXMLSchema(final XMLSchema aSchema) {
    schema = aSchema;
  }

  /**
   * @return true if the name of aSchema is one of the default ones
   */
  public boolean isDefaultSchema() {
    return XMLScripter.BASE_SCHEMA.getNamespace().equals(getNamespace())
        || XMLScripter.DEFAULT_COMMAND_SET_SCHEMA.getNamespace().equals(getNamespace());
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.wetator.testeditor.editors.AbstractWTETableViewerElement#hasData()
   */
  @Override
  public boolean hasData() {
    return null != getPrefix() && !"".equals(getPrefix()) || //
        null != getNamespace() && !"".equals(getNamespace()) || //
        null != getLocation() && !"".equals(getLocation());
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.wetator.testeditor.editors.AbstractWTETableViewerElement#set(int, java.lang.String)
   */
  @Override
  public void set(final int anIndex, final String aValue) {
    switch (anIndex) {
      case WTEXSDTableViewer.PREFIX:
        setPrefix(aValue);
        break;
      case WTEXSDTableViewer.NAMESPACE:
        setNamespace(aValue);
        break;
      case WTEXSDTableViewer.LOCATION:
        setLocation(aValue);
        break;
      default:
        break;
    }
  }

  /**
   * @return the schema
   */
  public XMLSchema getInnerSchema() {
    return schema;
  }

  /**
   * @return the prefix
   */
  public String getPrefix() {
    return schema.getPrefix();
  }

  /**
   * @param aPrefix the prefix to set
   */
  public void setPrefix(final String aPrefix) {
    schema.setPrefix(aPrefix);
  }

  /**
   * @return the namespace
   */
  public String getNamespace() {
    return schema.getNamespace();
  }

  /**
   * @param aNamespace the namespace to set
   */
  public void setNamespace(final String aNamespace) {
    schema.setNamespace(aNamespace);
  }

  /**
   * @return the location
   */
  public String getLocation() {
    return schema.getLocation();
  }

  /**
   * @param aLocation the location to set
   */
  public void setLocation(final String aLocation) {
    schema.setLocation(aLocation);
  }
}
