/*
 * Copyright (c) 2008-2017 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xml.scanner;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;

/**
 * The rule for detecting XML tags.
 * 
 * @author eclipse
 * @author tobwoerk
 */
public class TagRule extends MultiLineRule {

  /**
   * Constructor.
   * 
   * @param aToken the token to be returned on success
   */
  public TagRule(final IToken aToken) {
    super("<", ">", aToken);
  }

  /**
   * @see org.eclipse.jface.text.rules.PatternRule#sequenceDetected(org.eclipse.jface.text.rules.ICharacterScanner,
   *      char[], boolean)
   * @param aScanner the character scanner to be used
   * @param aSequence the sequence to be detected
   * @param anEOFAllowed indicates whether EOF terminates the pattern
   * @return true if an XML tag was detected, false if not (e.g. processing instruction or comment)
   */
  @Override
  protected boolean sequenceDetected(final ICharacterScanner aScanner, final char[] aSequence,
      final boolean anEOFAllowed) {
    final int tmpChar = aScanner.read();
    if (aSequence[0] == '<') {
      if (tmpChar == '?') {
        // processing instruction - abort
        aScanner.unread();
        return false;
      }
      if (tmpChar == '!') {
        aScanner.unread();
        // comment - abort
        return false;
      }
    } else if (aSequence[0] == '>') {
      aScanner.unread();
    }
    return super.sequenceDetected(aScanner, aSequence, anEOFAllowed);
  }
}
