/*
 * Copyright (c) 2008-2017 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.wte;

import org.wetator.core.Command;
import org.wetator.core.Parameter;
import org.wetator.testeditor.editors.AbstractWTETableViewerElement;

/**
 * A simple Wetator command.
 * 
 * @author tobwoerk
 * @author frank.danek
 */
public class WetatorCommand extends AbstractWTETableViewerElement {

  private Command command;

  /**
   * Default constructor.
   */
  public WetatorCommand() {
    this("", "", "", "", Boolean.FALSE);
  }

  /**
   * @param aCommandName the name of the command to set
   */
  public WetatorCommand(final String aCommandName) {
    super();
    command = new Command(aCommandName, false);
  }

  /**
   * @param aCommand the command to set
   * @param aParam the parameter to set
   * @param anOptionalParameter the optionalParameter to set
   * @param anOptionalParameter2 the optionalParameter2 to set
   * @param anIsComment the isComment to set
   */
  public WetatorCommand(final String aCommand, final String aParam, final String anOptionalParameter,
      final String anOptionalParameter2, final boolean anIsComment) {
    super();
    command = new Command(aCommand, anIsComment);
    command.setFirstParameter(new Parameter(aParam));
    command.setSecondParameter(new Parameter(anOptionalParameter));
    command.setThirdParameter(new Parameter(anOptionalParameter2));
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.wetator.testeditor.editors.AbstractWTETableViewerElement#hasData()
   */
  @Override
  public boolean hasData() {
    return null != getCommandName() && !"".equals(getCommandName()) || //
        null != getParameter() && !"".equals(getParameter()) || //
        null != getOptionalParameter() && !"".equals(getOptionalParameter()) || //
        null != getOptionalParameter2() && !"".equals(getOptionalParameter2()) || //
        isComment();
  }

  /**
   * {@inheritDoc}
   * 
   * @see org.wetator.testeditor.editors.AbstractWTETableViewerElement#set(int, java.lang.String)
   */
  @Override
  public void set(final int anIndex, final String aValue) {
    switch (anIndex) {
      case WTETableViewer.IS_COMMENT:
        throw new RuntimeException();
      case WTETableViewer.COMMAND:
        setCommand(aValue);
        break;
      case WTETableViewer.PARAMETER:
        setParameter(aValue);
        break;
      case WTETableViewer.OPTIONAL_PARAMETER:
        setOptionalParameter(aValue);
        break;
      case WTETableViewer.OPTIONAL_PARAMETER2:
        setOptionalParameter2(aValue);
        break;
      default:
        break;
    }
  }

  /**
   * @return the inner command
   */
  public Command getInnerCommand() {
    return command;
  }

  /**
   * @return the name of the command
   */
  public String getCommandName() {
    return command.getName();
  }

  /**
   * @param aCommand the command to set
   */
  public void setCommand(final String aCommand) {
    final Command tmpOldCommand = command;
    command = new Command(aCommand, tmpOldCommand.isComment());
    command.setFirstParameter(tmpOldCommand.getFirstParameter());
    command.setSecondParameter(tmpOldCommand.getSecondParameter());
    command.setThirdParameter(tmpOldCommand.getThirdParameter());
  }

  /**
   * @return the parameter
   */
  public String getParameter() {
    if (null == command.getFirstParameter()) {
      return null;
    }
    return command.getFirstParameter().getValue();
  }

  /**
   * @param aParameter the parameter to set
   */
  public void setParameter(final String aParameter) {
    command.setFirstParameter(new Parameter(aParameter));
  }

  /**
   * @return the optionalParameter
   */
  public String getOptionalParameter() {
    if (null == command.getSecondParameter()) {
      return null;
    }
    return command.getSecondParameter().getValue();
  }

  /**
   * @param anOptionalParameter the optionalParameter to set
   */
  public void setOptionalParameter(final String anOptionalParameter) {
    command.setSecondParameter(new Parameter(anOptionalParameter));
  }

  /**
   * @return the optionalParameter2
   */
  public String getOptionalParameter2() {
    if (null == command.getThirdParameter()) {
      return null;
    }
    return command.getThirdParameter().getValue();
  }

  /**
   * @param anOptionalParameter2 the optionalParameter2 to set
   */
  public void setOptionalParameter2(final String anOptionalParameter2) {
    command.setThirdParameter(new Parameter(anOptionalParameter2));
  }

  /**
   * @return the isComment
   */
  public boolean isComment() {
    return command.isComment();
  }

  /**
   * @param anIsComment the isComment to set
   */
  public void setComment(final boolean anIsComment) {
    final Command tmpOldCommand = command;
    command = new Command(tmpOldCommand.getName(), anIsComment);
    command.setFirstParameter(tmpOldCommand.getFirstParameter());
    command.setSecondParameter(tmpOldCommand.getSecondParameter());
    command.setThirdParameter(tmpOldCommand.getThirdParameter());
  }
}
