/*
 * Copyright (c) 2008-2017 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors;

import org.eclipse.osgi.util.NLS;

/**
 * Strings used by {@link org.wetator.testeditor.editors.wte.WTETableViewer}.
 * 
 * @author tobwoerk
 */
public final class WTEMessages extends NLS {
  private static final String BUNDLE_NAME = "org.wetator.testeditor.editors.WTEMessages";

  /**
   * The title of the view/tab.
   */
  public static String title;

  /**
   * Title of 2nd column of the {@link org.wetator.testeditor.editors.wte.WTETableViewer}.
   */
  public static String headerColumnCommand;
  /**
   * Title of 3rd column of the {@link org.wetator.testeditor.editors.wte.WTETableViewer}.
   */
  public static String headerColumnParameter;
  /**
   * Title of 4th column of the {@link org.wetator.testeditor.editors.wte.WTETableViewer}.
   */
  public static String headerColumnOptionalParameter;
  /**
   * Title of 5th column of the {@link org.wetator.testeditor.editors.wte.WTETableViewer}.
   */
  public static String headerColumnOptionalParameter2;

  /**
   * Title of 1st column of the {@link org.wetator.testeditor.editors.xsd.WTEXSDTableViewer}.
   */
  public static String headerColumnPrefix;
  /**
   * Title of 2nd column of the {@link org.wetator.testeditor.editors.xsd.WTEXSDTableViewer}.
   */
  public static String headerColumnNamespace;
  /**
   * Title of 3rd column of the {@link org.wetator.testeditor.editors.xsd.WTEXSDTableViewer}.
   */
  public static String headerColumnLocation;

  /**
   * Text for the 'Add Line' button.
   */
  public static String buttonAddLine;
  /**
   * ToolTip for the 'Add Line' button.
   */
  public static String buttonAddLineToolTip;
  /**
   * Text for the 'Delete Line' button.
   */
  public static String buttonDeleteLine;
  /**
   * ToolTip for the 'Delete Line' button.
   */
  public static String buttonDeleteLineToolTip;

  /**
   * The title of the wizard.
   */
  public static String wizardTitle;
  /**
   * The title of the wizard's first page.
   */
  public static String wizardFirstPageTitle;
  /**
   * The description of wizard's the first page.
   */
  public static String wizardFirstPageDescription;

  static {
    // load message values from bundle file
    NLS.initializeMessages(BUNDLE_NAME, WTEMessages.class);
  }

  private WTEMessages() {
    // cannot create new instance
  }
}
