/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.wizards.newfile;

import java.io.InputStream;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.wetator.testeditor.editors.WTEMessages;

/**
 * Extends the {@link WizardNewFileCreationPage} to load WTE specific texts
 * and provide a suitable WTE file for {@link #getInitialContents()} to allow
 * users to start with an empty WTE file.
 * 
 * @author chriseverty
 * @author tobwoerk
 */
public class WetatorNewFileWizardPage extends WizardNewFileCreationPage {

  /**
   * The name of the page.
   */
  public static final String PAGE_NAME = "NewWetatorFileWizardPage";
  /**
   * The only file extension allowed for this page's file name field.
   */
  public static final String FILE_EXTENSION = "wet";

  /**
   * @param aSelection the current resource selection.
   */
  public WetatorNewFileWizardPage(final IStructuredSelection aSelection) {
    super(PAGE_NAME, aSelection);
    setTitle(WTEMessages.wizardFirstPageTitle);
    setDescription(WTEMessages.wizardFirstPageDescription);
    setFileExtension(FILE_EXTENSION);
  }

  @Override
  protected InputStream getInitialContents() {
    final InputStream tmpNewFile = this.getClass().getResourceAsStream("resources/newTestFile.wet");
    return tmpNewFile;
  }
}
