/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import org.wetator.scripter.xml.XMLSchema;
import org.wetator.testeditor.editors.xsd.WetatorXMLSchema;

/**
 * Some utilities for the WTE.
 * 
 * @author tobwoerk
 * @author frank.danek
 */
public final class WTEUtil {

  private static final Pattern PRINTABLE_PATTERN = Pattern.compile("\\p{Print}");

  /**
   * @param aWetatorSchemaList the list to convert
   * @return the casted list
   */
  public static List<XMLSchema> convertToXMLSchemaList(final List<WetatorXMLSchema> aWetatorSchemaList) {
    final List<XMLSchema> tmpXMLSchemaList = new ArrayList<XMLSchema>();
    for (final WetatorXMLSchema tmpSchema : aWetatorSchemaList) {
      tmpXMLSchemaList.add(tmpSchema.getInnerSchema());
    }
    return tmpXMLSchemaList;
  }

  /**
   * @param anXMLSchemaList the list to cast
   * @return the casted list
   */
  public static List<WetatorXMLSchema> convertToWetatorXMLSchemaList(final List<XMLSchema> anXMLSchemaList) {
    final List<WetatorXMLSchema> tmpWetatorXMLSchemaList = new ArrayList<WetatorXMLSchema>();
    for (final XMLSchema tmpSchema : anXMLSchemaList) {
      tmpWetatorXMLSchemaList.add(new WetatorXMLSchema(tmpSchema));
    }
    return tmpWetatorXMLSchemaList;
  }

  /**
   * @param aChar the char to check
   * @return true if the given char is printable, false if not
   */
  public static boolean isPrintable(final char aChar) {
    return PRINTABLE_PATTERN.matcher(String.valueOf(aChar)).matches();
  }

  private WTEUtil() {
    // prohibit instantiation
  }
}
