/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xsd;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.wetator.scripter.XMLScripter;
import org.wetator.testeditor.editors.WTEColors;

/**
 * Label provider for all columns of the {@link org.wetator.testeditor.editors.wte.WTETableViewer}.
 * 
 * @author tobwoerk
 */
public class WTEXSDLabelProvider extends ColumnLabelProvider {

  private int column;

  /**
   * Constructor.
   * 
   * @param aColumn the column to provide labels for
   */
  public WTEXSDLabelProvider(final int aColumn) {
    column = aColumn;
  }

  @Override
  public void update(final ViewerCell aCell) {
    String tmpResult = "";
    final WetatorXMLSchema tmpSchema = (WetatorXMLSchema) aCell.getElement();

    if (XMLScripter.BASE_SCHEMA.getNamespace().equals(tmpSchema.getNamespace())
        || XMLScripter.DEFAULT_COMMAND_SET_SCHEMA.getNamespace().equals(tmpSchema.getNamespace())) {
      aCell.setForeground(new Color(Display.getCurrent(), WTEColors.DARK_GREY));
    } else {
      aCell.setForeground(null);
    }
    aCell.setBackground(null);

    switch (column) {
      case WTEXSDTableViewer.PREFIX:
        tmpResult = tmpSchema.getPrefix();
        break;
      case WTEXSDTableViewer.NAMESPACE:
        tmpResult = tmpSchema.getNamespace();
        break;
      case WTEXSDTableViewer.LOCATION:
        tmpResult = tmpSchema.getLocation();
        break;
      default:
        break;
    }
    aCell.setText(tmpResult);
  }
}
