/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xml.scanner;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.wetator.testeditor.editors.xml.XMLColorConstants;
import org.wetator.testeditor.editors.xml.XMLColorManager;
import org.wetator.testeditor.editors.xml.XMLWhitespaceDetector;

/**
 * Scanner for detecting the processing instructions of XML files.
 * 
 * @author eclipse
 * @author tobwoerk
 */
public class XMLScanner extends RuleBasedScanner {

  /**
   * Constructor defining the rules for the processing instructions.
   * 
   * @param aManager the color manager
   */
  public XMLScanner(final XMLColorManager aManager) {
    final IToken tmpProcInstr = new Token(new TextAttribute(aManager.getColor(XMLColorConstants.PROC_INSTR)));

    final IRule[] tmpRules = new IRule[2];
    // Add rule for processing instructions
    tmpRules[0] = new SingleLineRule("<?", "?>", tmpProcInstr);
    // Add generic whitespace rule.
    tmpRules[1] = new WhitespaceRule(new XMLWhitespaceDetector());

    setRules(tmpRules);
  }
}
