/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xml.scanner;

import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

/**
 * Scanner for the different partitions of an XML file.
 * 
 * @author eclipse
 * @author tobwoerk
 */
public class XMLPartitionScanner extends RuleBasedPartitionScanner {
  /**
   * Constant for XML comment.
   */
  public static final String XML_COMMENT = "__xml_comment";
  /**
   * Constant for XML tag.
   */
  public static final String XML_TAG = "__xml_tag";

  /**
   * Constructor defining the rules for the XML partitions.
   */
  public XMLPartitionScanner() {
    final IToken tmpXmlComment = new Token(XML_COMMENT);
    final IToken tmpXmlTag = new Token(XML_TAG);

    final IPredicateRule[] tmpRules = new IPredicateRule[2];

    tmpRules[0] = new MultiLineRule("<!--", "-->", tmpXmlComment);
    tmpRules[1] = new TagRule(tmpXmlTag);

    setPredicateRules(tmpRules);
  }
}
