/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xml;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.wetator.testeditor.editors.xml.scanner.XMLPartitionScanner;

/**
 * An easy XML source editor to be used in the WTE.
 * 
 * @author eclipse
 * @author tobwoerk
 */
public class XMLEditor extends TextEditor {

  private XMLColorManager colorManager;

  /**
   * Default constructor.
   */
  public XMLEditor() {
    super();
    colorManager = new XMLColorManager();
    setSourceViewerConfiguration(new XMLEditorConfiguration(colorManager));
  }

  /**
   * @see org.eclipse.ui.editors.text.TextEditor#dispose()
   */
  @Override
  public void dispose() {
    colorManager.dispose();
    super.dispose();
  }

  /**
   * @see org.eclipse.ui.part.EditorPart#setInput(org.eclipse.ui.IEditorInput)
   * @param anEditorInput the input to set
   * @throws CoreException if errors
   */
  @Override
  protected void doSetInput(final IEditorInput anEditorInput) throws CoreException {
    if (anEditorInput instanceof FileStoreEditorInput) {
      // eclipse-external files
      setDocumentProvider(new XMLExternalDocumentProvider());
    } else {
      // only IFileEditorInput expected (eclipse-internal files)
      setDocumentProvider(new XMLDocumentProvider());
    }

    super.doSetInput(anEditorInput);
  }

  /**
   * @param aDocument the document to partition
   */
  public static void partitionDocument(final IDocument aDocument) {
    final IDocumentPartitioner tmpPartitioner = new FastPartitioner(new XMLPartitionScanner(), new String[] {
        XMLPartitionScanner.XML_TAG, XMLPartitionScanner.XML_COMMENT });
    tmpPartitioner.connect(aDocument);
    aDocument.setDocumentPartitioner(tmpPartitioner);
  }
}
