/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xml;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.FileDocumentProvider;

/**
 * Handles initialization and provision of XML documents.
 * 
 * @author tobwoerk
 * @author frank.danek
 */
public class XMLDocumentProvider extends FileDocumentProvider {

  /**
   * @see org.eclipse.ui.editors.text.StorageDocumentProvider#createDocument(java.lang.Object)
   * @param anElement the element to create the document from
   * @return the created document (may be null)
   * @throws CoreException if creating the document fails
   */
  @Override
  protected IDocument createDocument(final Object anElement) throws CoreException {
    final IDocument tmpDocument = super.createDocument(anElement);
    if (tmpDocument != null) {
      XMLEditor.partitionDocument(tmpDocument);
    }
    return tmpDocument;
  }
}