/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/**
 * The color manager for the {@link org.wetator.testeditor.editors.xml.XMLEditor}.
 * 
 * @author eclipse
 * @author tobwoerk
 */
public class XMLColorManager {

  /**
   * The color table.
   */
  protected Map<RGB, Color> colorTable = new HashMap<RGB, Color>(10);

  /**
   * Disposes all colors in the color table.
   */
  public void dispose() {
    final Iterator<Color> tmpColorTableIterator = colorTable.values().iterator();
    while (tmpColorTableIterator.hasNext()) {
      tmpColorTableIterator.next().dispose();
    }
  }

  /**
   * @param anRgb the color to get
   * @return the given color from the color table, creates the color if not existent
   */
  public Color getColor(final RGB anRgb) {
    Color tmpColor = colorTable.get(anRgb);
    if (tmpColor == null) {
      tmpColor = new Color(Display.getCurrent(), anRgb);
      colorTable.put(anRgb, tmpColor);
    }
    return tmpColor;
  }
}
