/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.xml;

import org.eclipse.swt.graphics.RGB;
import org.wetator.testeditor.editors.WTEColors;

/**
 * Contains the colors to use in the {@link org.wetator.testeditor.editors.xml.XMLEditor}.
 * 
 * @author tobwoerk
 */
public abstract class XMLColorConstants {

  /**
   * Color for comments.
   */
  public static final RGB XML_COMMENT = new RGB(63, 94, 213);
  /**
   * Color for processing instructions.
   */
  public static final RGB PROC_INSTR = new RGB(63, 127, 144);
  /**
   * Color for element content.
   */
  public static final RGB STRING = WTEColors.BLACK;
  /**
   * Color for default content.
   */
  public static final RGB DEFAULT = WTEColors.BLACK;
  /**
   * Color for tags.
   */
  public static final RGB TAG = new RGB(63, 127, 144);

  private XMLColorConstants() {
    // prohibit instantiation
  }
}
