/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.wte;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.wetator.testeditor.editors.TagInformation;
import org.wetator.testeditor.editors.WTEColors;
import org.wetator.testeditor.editors.WetatorTestContentManager;

/**
 * Label provider for all columns of the {@link WTETableViewer}.
 * 
 * @author tobwoerk
 */
public class WTELabelProvider extends ColumnLabelProvider {

  private int column;

  private WetatorTestContentManager contentManager;

  /**
   * Constructor.
   * 
   * @param aColumn the column to provide labels for
   * @param aContentManager the content manager
   */
  public WTELabelProvider(final int aColumn, final WetatorTestContentManager aContentManager) {
    column = aColumn;
    contentManager = aContentManager;
  }

  @Override
  public String getToolTipText(final Object anElement) {
    final WetatorCommand tmpCommand = (WetatorCommand) anElement;
    final TagInformation tmpTagInfo = contentManager.getTagInformation(tmpCommand.getInnerCommand(), column);
    if (null == tmpTagInfo) {
      return null;
    }
    return " " + tmpTagInfo.getName() + "\n\n" + tmpTagInfo.getDocumentation() + " ";
  }

  @Override
  public void update(final ViewerCell aCell) {
    String tmpResult = "";
    final WetatorCommand tmpCommand = (WetatorCommand) aCell.getElement();

    if (tmpCommand.isComment()) {
      aCell.setForeground(new Color(Display.getCurrent(), WTEColors.WHITE));
      aCell.setBackground(new Color(Display.getCurrent(), WTEColors.WETATOR_ORANGE));
    } else {
      aCell.setForeground(null);
      aCell.setBackground(null);
    }

    switch (column) {
      case WTETableViewer.IS_COMMENT:
        if (tmpCommand.isComment()) {
          tmpResult = "#";
        } else {
          tmpResult = null;
        }
        break;
      case WTETableViewer.COMMAND:
        tmpResult = tmpCommand.getCommandName();
        break;
      case WTETableViewer.PARAMETER:
        tmpResult = tmpCommand.getParameter();
        break;
      case WTETableViewer.OPTIONAL_PARAMETER:
        tmpResult = tmpCommand.getOptionalParameter();
        break;
      case WTETableViewer.OPTIONAL_PARAMETER2:
        if (tmpCommand.hasData() && !contentManager.isCommandTypeWith3Parameters(tmpCommand.getCommandName())) {
          aCell.setBackground(new Color(Display.getCurrent(), WTEColors.LIGHT_GREY));
        }

        tmpResult = tmpCommand.getOptionalParameter2();
        break;
      default:
        break;
    }
    aCell.setText(tmpResult);
  }
}
