/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.wte;

import java.util.List;

import org.wetator.testeditor.editors.WetatorTestContentManager;

/**
 * The interface for the {@link WTETableViewer}.
 *
 * @author tobwoerk
 * @author frank.danek
 */
public interface IWTETableViewer {

  /**
   * @param aDirty the dirty to set
   */
  void setDirty(boolean aDirty);

  /**
   * Return the column names in a collection.
   *
   * @return List containing column names
   */
  List<String> getColumnNames();

  /**
   * @return the contentManager
   */
  WetatorTestContentManager getContentManager();
}