/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.exception;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.wetator.testeditor.Activator;

/**
 * A small util for eclipse error handling.
 * 
 * @author tobwoerk
 */
public abstract class EclipseErrorUtil {

  /**
   * Logs an error.
   * 
   * @param anException the exception to log
   * @param aClassName the logging class' name
   */
  public static void logError(final Exception anException, final String aClassName) {
    final Status tmpStatus = createErrorStatus(anException, aClassName);
    Activator.getDefault().getLog().log(tmpStatus);
  }

  /**
   * Creates an error {@link Status}.
   * 
   * @param anException the exception
   * @param aClassName the logging class' name
   * @return the {@link Status} according to the exception.
   */
  public static Status createErrorStatus(final Exception anException, final String aClassName) {
    String tmpReason = anException.getMessage();
    if (null == tmpReason) {
      tmpReason = anException.getClass().getSimpleName();
    }
    final Status tmpStatus = new Status(IStatus.ERROR, aClassName, tmpReason, anException);
    return tmpStatus;
  }
}
