/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors.edit;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.wetator.testeditor.editors.AbstractWTETableViewer;
import org.wetator.testeditor.editors.WetatorTestMultiPageEditor;

/**
 * Abstract handler for the elements in WTE table viewers.
 * 
 * @author tobwoerk
 */
public abstract class AbstractWTETableViewerCommandHandler extends AbstractHandler {

  /**
   * {@inheritDoc}
   * 
   * @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
   */
  @Override
  public Object execute(final ExecutionEvent anEvent) throws ExecutionException {
    final IEditorPart tmpEditor = HandlerUtil.getActiveEditor(anEvent);
    if (tmpEditor instanceof WetatorTestMultiPageEditor) {
      final WetatorTestMultiPageEditor tmpWTE = (WetatorTestMultiPageEditor) tmpEditor;
      if (tmpWTE.getActivePage() == tmpWTE.indexWTE) {
        execute(tmpWTE.wte);
      } else if (tmpWTE.getActivePage() == tmpWTE.indexXSDEditor) {
        execute(tmpWTE.xsd);
      }
    }
    return null;
  }

  /**
   * Real execution.
   * 
   * @param aTableViewer the active table viewer
   */
  protected abstract void execute(final AbstractWTETableViewer<?> aTableViewer);
}
