/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

/**
 * Manages the installation/deinstallation of global actions for multi-page
 * editors. Responsible for the redirection of global actions to the active
 * editor. Multi-page contributor replaces the contributors for the individual
 * editors in the multi-page editor.
 *
 * @author tobwoerk
 */
public class WetatorTestEditorContributor extends MultiPageEditorActionBarContributor {
  private IEditorPart activeEditorPart;

  /**
   * Returns the action registered with the given text editor.
   *
   * @param anEditor
   *        the editor to get the action from
   * @param anActionID
   *        the action id of the action to get
   * @return IAction or null if editor is null.
   */
  protected IAction getAction(final ITextEditor anEditor, final String anActionID) {
    if (null == anEditor) {
      return null;
    }
    return anEditor.getAction(anActionID);
  }

  /**
   * @see org.eclipse.ui.part.MultiPageEditorActionBarContributor#setActivePage(org.eclipse.ui.IEditorPart)
   * @param aPart the part that should become active
   */
  @Override
  public void setActivePage(final IEditorPart aPart) {
    if (activeEditorPart == aPart) {
      return;
    }

    activeEditorPart = aPart;

    final IActionBars tmpActionBars = getActionBars();
    if (tmpActionBars != null) {

      ITextEditor tmpEditor;
      if (aPart instanceof ITextEditor) {
        tmpEditor = (ITextEditor) aPart;
      } else {
        tmpEditor = null;
      }

      tmpActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(),
          getAction(tmpEditor, ITextEditorActionConstants.DELETE));
      tmpActionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(),
          getAction(tmpEditor, ITextEditorActionConstants.UNDO));
      tmpActionBars.setGlobalActionHandler(ActionFactory.REDO.getId(),
          getAction(tmpEditor, ITextEditorActionConstants.REDO));
      tmpActionBars.setGlobalActionHandler(ActionFactory.CUT.getId(),
          getAction(tmpEditor, ITextEditorActionConstants.CUT));
      tmpActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(),
          getAction(tmpEditor, ITextEditorActionConstants.COPY));
      tmpActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(),
          getAction(tmpEditor, ITextEditorActionConstants.PASTE));
      tmpActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(),
          getAction(tmpEditor, ITextEditorActionConstants.SELECT_ALL));
      tmpActionBars.setGlobalActionHandler(ActionFactory.FIND.getId(),
          getAction(tmpEditor, ITextEditorActionConstants.FIND));
      tmpActionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(),
          getAction(tmpEditor, IDEActionFactory.BOOKMARK.getId()));
      tmpActionBars.updateActionBars();
    }
  }
}
