/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors;

import org.eclipse.swt.graphics.RGB;

/**
 * Contains the colors for the WTE.
 * 
 * @author tobwoerk
 */
public abstract class WTEColors {

  /**
   * Just black.
   */
  public static final RGB BLACK = new RGB(0, 0, 0);
  /**
   * Just white.
   */
  public static final RGB WHITE = new RGB(255, 255, 255);

  /**
   * Wetator orange.
   */
  public static final RGB WETATOR_ORANGE = new RGB(255, 102, 0);
  /**
   * Wetator green.
   */
  public static final RGB WETATOR_GREEN = new RGB(172, 201, 82);
  /**
   * Wetator blue.
   */
  public static final RGB WETATOR_BLUE = new RGB(0, 118, 156);

  /**
   * Wetator grey.
   */
  public static final RGB DARK_GREY = new RGB(86, 86, 86);
  /**
   * Wetator light grey.
   */
  public static final RGB LIGHT_GREY = new RGB(204, 204, 204);

  /**
   * Eclipse selection blue.
   */
  public static final RGB ECLIPSE_BLUE = new RGB(56, 117, 215);

  private WTEColors() {
    // prohibit instantiation
  }
}
