/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor.editors;

/**
 * Abstract element shown in an {@link AbstractWTETableViewer}.
 * 
 * @author tobwoerk
 */
public abstract class AbstractWTETableViewerElement {

  /**
   * @return true if any data is available for the element, false if not
   */
  public abstract boolean hasData();

  /**
   * Convenience setter.
   * 
   * @param aColumnIndex the index according to the corresponding table viewer constants
   * @param aValue the value to set
   */
  public abstract void set(final int aColumnIndex, final String aValue);
}
