/*
 * Copyright (c) 2008-2016 wetator.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wetator.testeditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle.
 * 
 * @author tobwoerk
 */
public class Activator extends AbstractUIPlugin {

  /**
   * The plug-in ID.
   */
  public static final String PLUGIN_ID = "org.wetator.WetatorTestEditor"; //$NON-NLS-1$

  // The shared instance
  private static Activator plugin;

  /**
   * The constructor.
   */
  public Activator() {
    // nothing to do
  }

  /**
   * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
   * @param aContext the context to start
   * @throws Exception in case of errors
   */
  @Override
  public void start(final BundleContext aContext) throws Exception {
    super.start(aContext);
    plugin = this;
  }

  /**
   * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
   * @param aContext the context to stop
   * @throws Exception in case of errors
   */
  @Override
  public void stop(final BundleContext aContext) throws Exception {
    plugin = null;
    super.stop(aContext);
  }

  /**
   * Returns the shared instance.
   * 
   * @return the shared instance
   */
  public static Activator getDefault() {
    return plugin;
  }

  /**
   * Returns an image descriptor for the image file at the given plug-in.
   * relative path
   * 
   * @param aPath
   *        the path
   * @return the image descriptor
   */
  public static ImageDescriptor getImageDescriptor(final String aPath) {
    return imageDescriptorFromPlugin(PLUGIN_ID, aPath);
  }
}
