/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scripter.xml;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wetator.scripter.xml.XMLSchema;

public class SchemaFinder {
    private List<XMLSchema> schemas;

    public SchemaFinder(Reader anXMLReader) throws XMLStreamException {
        this.findSchemas(anXMLReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findSchemas(Reader anXMLReader) throws XMLStreamException {
        XMLInputFactory tmpFactory = XMLInputFactory.newInstance();
        XMLStreamReader tmpReader = tmpFactory.createXMLStreamReader(anXMLReader);
        this.schemas = new ArrayList<XMLSchema>();
        try {
            while (tmpReader.hasNext()) {
                if (tmpReader.next() != 1) continue;
                int tmpSchemaCount = tmpReader.getNamespaceCount();
                if (tmpSchemaCount > 0) {
                    HashMap<String, String> tmpNamespacePrefixes = new HashMap<String, String>();
                    for (int i = 0; i < tmpSchemaCount; ++i) {
                        String tmpPrefix = tmpReader.getNamespacePrefix(i);
                        String tmpNamespaceURI = tmpReader.getNamespaceURI(i);
                        tmpNamespacePrefixes.put(tmpNamespaceURI, tmpPrefix);
                    }
                    String tmpSchemaLocation = tmpReader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                    if (tmpSchemaLocation != null) {
                        tmpSchemaLocation = tmpSchemaLocation.replace("  ", " ");
                        String[] tmpSchemaLocations = tmpSchemaLocation.split(" ");
                        for (int i = 0; i < tmpSchemaLocations.length; i += 2) {
                            if ("".equals(tmpSchemaLocations[i].trim())) continue;
                            String tmpNamespaceURI = tmpSchemaLocations[i];
                            String tmpPrefix = (String)tmpNamespacePrefixes.get(tmpNamespaceURI);
                            XMLSchema tmpSchema = new XMLSchema(tmpPrefix, tmpNamespaceURI, tmpSchemaLocations[i + 1]);
                            this.schemas.add(tmpSchema);
                        }
                    }
                }
                break;
            }
        }
        finally {
            try {
                tmpReader.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
    }

    public List<XMLSchema> getSchemas() {
        return this.schemas;
    }
}

