/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scripter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.wetator.core.Command;
import org.wetator.core.IScripter;
import org.wetator.core.Parameter;
import org.wetator.exception.InvalidInputException;
import org.wetator.util.ContentUtil;
import org.wetator.util.NormalizedString;

public final class ExcelScripter
implements IScripter {
    private static final Logger LOG = LogManager.getLogger(ExcelScripter.class);
    private static final String PROPERTY_PREFIX = "wetator.scripter.excel.";
    private static final String PROPERTY_LOCALE = "wetator.scripter.excel.locale";
    private static final String EXCEL_FILE_EXTENSION_XLS = ".xls";
    private static final String EXCEL_FILE_EXTENSION_XLSX = ".xlsx";
    private static final int COMMENT_COLUMN_NO = 0;
    private static final int COMMAND_NAME_COLUMN_NO = 1;
    private static final int FIRST_PARAM_COLUMN_NO = 2;
    private static final int SECOND_PARAM_COLUMN_NO = 3;
    private static final int THIRD_PARAM_COLUMN_NO = 4;
    private File file;
    private List<Command> commands;
    private Locale locale = Locale.getDefault();

    @Override
    public void initialize(Properties aConfiguration) {
        String tmpPropLocale = aConfiguration.getProperty(PROPERTY_LOCALE);
        if (StringUtils.isEmpty((CharSequence)tmpPropLocale)) {
            return;
        }
        try {
            this.locale = LocaleUtils.toLocale((String)tmpPropLocale);
        }
        catch (Exception e) {
            LOG.error("Property 'wetator.scripter.excel.locale=" + tmpPropLocale + "' is not a valid locale; using default '" + this.locale + "instead (" + e.getMessage() + ").");
        }
    }

    @Override
    public IScripter.IsSupportedResult isSupported(File aFile) {
        String tmpFileName = aFile.getName().toLowerCase(Locale.ROOT);
        if (!tmpFileName.endsWith(EXCEL_FILE_EXTENSION_XLS) && !tmpFileName.endsWith(EXCEL_FILE_EXTENSION_XLSX)) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by ExcelScripter. Extension is not '" + EXCEL_FILE_EXTENSION_XLS + "' or '" + EXCEL_FILE_EXTENSION_XLSX + "'.");
        }
        if (!aFile.exists() || !aFile.isFile()) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by ExcelScripter. Could not find file.");
        }
        if (!aFile.canRead()) {
            return new IScripter.IsSupportedResult("File '" + aFile.getName() + "' not supported by ExcelScripter. Could not read file.");
        }
        return IScripter.IS_SUPPORTED;
    }

    @Override
    public void script(File aFile) throws InvalidInputException {
        this.file = aFile;
        this.commands = this.readCommands();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Command> readCommands() throws InvalidInputException {
        LinkedList<Command> tmpResult = new LinkedList<Command>();
        try (InputStream tmpInputStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);){
            try (Workbook tmpWorkbook = WorkbookFactory.create((InputStream)tmpInputStream);){
                int tmpSheetNo = -1;
                for (int i = 0; i < tmpWorkbook.getNumberOfSheets(); ++i) {
                    String tmpSheetName = tmpWorkbook.getSheetName(i);
                    if (!StringUtils.isNotEmpty((CharSequence)tmpSheetName) || !tmpSheetName.toLowerCase(Locale.ROOT).contains("test")) continue;
                    tmpSheetNo = i;
                    break;
                }
                if (tmpSheetNo < 0) {
                    throw new InvalidInputException("No test sheet found in file '" + FilenameUtils.normalize((String)this.file.getAbsolutePath()) + "'.");
                }
                Sheet tmpSheet = tmpWorkbook.getSheetAt(tmpSheetNo);
                FormulaEvaluator tmpFormulaEvaluator = tmpWorkbook.getCreationHelper().createFormulaEvaluator();
                for (int tmpLine = 0; tmpLine <= tmpSheet.getLastRowNum(); ++tmpLine) {
                    Row tmpRow = tmpSheet.getRow(tmpLine);
                    if (null == tmpRow) continue;
                    String tmpCommentString = ContentUtil.readCellContentAsString(tmpRow, 0, tmpFormulaEvaluator, this.locale);
                    boolean tmpCommentFlag = StringUtils.isNotEmpty((CharSequence)tmpCommentString);
                    String tmpCommandName = ContentUtil.readCellContentAsString(tmpRow, 1, tmpFormulaEvaluator, this.locale);
                    if (StringUtils.isNotEmpty((CharSequence)tmpCommandName)) {
                        tmpCommandName = tmpCommandName.replace(' ', '-').replace('_', '-').toLowerCase(Locale.ROOT);
                    }
                    tmpCommandName = new NormalizedString(tmpCommandName).toString();
                    if (tmpCommentFlag && StringUtils.isEmpty((CharSequence)tmpCommandName)) {
                        tmpCommandName = "Comment";
                    }
                    if (StringUtils.isEmpty((CharSequence)tmpCommandName)) continue;
                    Command tmpCommand = new Command(tmpCommandName, tmpCommentFlag);
                    Parameter tmpParameter = this.readCellContentAsParameter(tmpRow, 2, tmpFormulaEvaluator);
                    if (null != tmpParameter) {
                        tmpCommand.setFirstParameter(tmpParameter);
                    }
                    if (null != (tmpParameter = this.readCellContentAsParameter(tmpRow, 3, tmpFormulaEvaluator))) {
                        tmpCommand.setSecondParameter(tmpParameter);
                    }
                    if (null != (tmpParameter = this.readCellContentAsParameter(tmpRow, 4, tmpFormulaEvaluator))) {
                        tmpCommand.setThirdParameter(tmpParameter);
                    }
                    tmpCommand.setLineNo(tmpLine + 1);
                    tmpResult.add(tmpCommand);
                }
            }
            LinkedList<Command> linkedList = tmpResult;
            return linkedList;
        }
        catch (FileNotFoundException e) {
            throw new InvalidInputException("Could not find file '" + FilenameUtils.normalize((String)this.file.getAbsolutePath()) + "'.", e);
        }
        catch (IOException e) {
            throw new InvalidInputException("Error parsing file '" + FilenameUtils.normalize((String)this.file.getAbsolutePath()) + "' (" + e.getMessage() + ").", e);
        }
    }

    private Parameter readCellContentAsParameter(Row aRow, int aColumnsNo, FormulaEvaluator aFormulaEvaluator) {
        String tmpContent = ContentUtil.readCellContentAsString(aRow, aColumnsNo, aFormulaEvaluator, this.locale);
        if (StringUtils.isEmpty((CharSequence)tmpContent)) {
            return null;
        }
        return new Parameter(tmpContent);
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }
}

