/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scriptcreator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wetator.core.Command;
import org.wetator.scriptcreator.IScriptCreator;

public class WikiTextScriptCreator
implements IScriptCreator {
    private List<Command> commands;
    private String fileName;
    private File outputDir;

    @Override
    public void createScript() {
        try {
            File tmpFile = new File(this.outputDir, this.fileName + ".wett");
            try (BufferedWriter tmpWriter = Files.newBufferedWriter(tmpFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                for (Command tmpCommand : this.commands) {
                    if (tmpCommand.isComment()) {
                        tmpWriter.write("#");
                        if (StringUtils.isNotBlank((CharSequence)tmpCommand.getName())) {
                            tmpWriter.write(" ");
                            tmpWriter.write(tmpCommand.getName());
                        }
                        if (tmpCommand.getFirstParameter() != null && StringUtils.isNotBlank((CharSequence)tmpCommand.getFirstParameter().getValue())) {
                            tmpWriter.write(" ");
                            tmpWriter.write(tmpCommand.getFirstParameter().getValue());
                        }
                        if (tmpCommand.getSecondParameter() != null && StringUtils.isNotBlank((CharSequence)tmpCommand.getSecondParameter().getValue())) {
                            tmpWriter.write(" ");
                            tmpWriter.write(tmpCommand.getSecondParameter().getValue());
                        }
                    } else if (tmpCommand.getFirstParameter() != null) {
                        tmpWriter.write(StringUtils.rightPad((String)tmpCommand.getName(), (int)20));
                        tmpWriter.write(" || ");
                        tmpWriter.write(tmpCommand.getFirstParameter().getValue());
                        if (tmpCommand.getSecondParameter() != null) {
                            tmpWriter.write("  || ");
                            tmpWriter.write(tmpCommand.getSecondParameter().getValue());
                        }
                    } else {
                        tmpWriter.write(tmpCommand.getName());
                    }
                    tmpWriter.write(System.lineSeparator());
                }
            }
            catch (FileNotFoundException e) {
                FileNotFoundException tmpException = new FileNotFoundException("Can't create output file '" + tmpFile.getAbsolutePath() + "'.");
                tmpException.initCause(e);
                throw tmpException;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setCommands(List<Command> aCommandList) {
        this.commands = aCommandList;
    }

    @Override
    public void setFileName(String aFileName) {
        this.fileName = aFileName;
    }

    @Override
    public void setOutputDir(String anOutputDir) {
        this.outputDir = new File(anOutputDir);
    }
}

