/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.progresslistener;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.wetator.Version;
import org.wetator.core.Command;
import org.wetator.core.IProgressListener;
import org.wetator.core.TestCase;
import org.wetator.core.WetatorConfiguration;
import org.wetator.core.WetatorContext;
import org.wetator.core.WetatorEngine;
import org.wetator.exception.AssertionException;
import org.wetator.util.Output;

public class StdOutProgressListener
implements IProgressListener {
    protected Output output = new Output(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()), "  ");
    private static final int DOTS_PER_LINE = 100;
    private int dotCount;
    private int testCaseCountTotal;
    private int testCaseCountProcessed;
    private int testCountProcessed;
    private int testCountError;
    private int testCountFailure;
    private int testCountIgnored;
    private long stepCountTotal;
    private long stepCountError;
    private long stepCountFailure;
    private long stepCountIgnore;
    private TestResult testResult;

    @Override
    public void init(WetatorEngine aWetatorEngine) {
        File tmpVariablesFile;
        this.println(Version.getProductName() + " " + Version.getVersion());
        this.output.indent();
        this.println("using " + com.gargoylesoftware.htmlunit.Version.getProductName() + " version " + com.gargoylesoftware.htmlunit.Version.getProductVersion());
        File tmpConfigFile = aWetatorEngine.getConfigFile();
        if (null != tmpConfigFile) {
            this.println("Config:     '" + FilenameUtils.normalize((String)tmpConfigFile.getAbsolutePath()) + "'");
        }
        if (null != (tmpVariablesFile = aWetatorEngine.getVariablesFile())) {
            this.println("Variables   '" + FilenameUtils.normalize((String)tmpVariablesFile.getAbsolutePath()) + "'");
        }
    }

    @Override
    public void start(WetatorEngine aWetatorEngine) {
        this.testCaseCountProcessed = 0;
        this.testCountProcessed = 0;
        this.testCountError = 0;
        this.testCountFailure = 0;
        this.testCountIgnored = 0;
        this.stepCountTotal = 0L;
        this.stepCountError = 0L;
        this.stepCountFailure = 0L;
        this.stepCountIgnore = 0L;
        WetatorConfiguration tmpConfiguration = aWetatorEngine.getConfiguration();
        if (tmpConfiguration != null) {
            if (StringUtils.isNotEmpty((CharSequence)tmpConfiguration.getProxyHost())) {
                this.println("    proxy:  '" + tmpConfiguration.getProxyHost() + ":" + tmpConfiguration.getProxyPort() + "'");
                Set<String> tmpNonProxyHosts = tmpConfiguration.getProxyHostsToBypass();
                boolean tmpNotFirst = false;
                StringBuilder tmpProxies = new StringBuilder("    bypass: ");
                for (String tmpString : tmpNonProxyHosts) {
                    String tmpHostsToProxyBypass = tmpString.trim();
                    if (tmpNotFirst) {
                        tmpProxies.append(", ");
                    }
                    tmpProxies.append('\'').append(tmpHostsToProxyBypass).append('\'');
                    tmpNotFirst = true;
                }
                this.println(tmpProxies.toString());
            }
            this.print("OutputDir:  '" + FilenameUtils.normalize((String)tmpConfiguration.getOutputDir().getAbsolutePath()) + "'");
            if (tmpConfiguration.isAppendResultsEnabled()) {
                this.print(" (appending)");
            }
            this.println("");
            boolean tmpFirst = true;
            for (String tmpTemplate : tmpConfiguration.getXslTemplates()) {
                if (tmpFirst) {
                    this.println("Templates:  '" + tmpTemplate + "'");
                    tmpFirst = false;
                    this.output.indent().indent().indent().indent().indent().indent();
                    continue;
                }
                this.println("'" + tmpTemplate + "'");
            }
            if (!tmpFirst) {
                this.output.unindent().unindent().unindent().unindent().unindent().unindent();
            }
        }
        List<TestCase> tmpTestCases = aWetatorEngine.getTestCases();
        this.testCaseCountTotal = tmpTestCases.size();
        if (tmpTestCases.isEmpty()) {
            this.println("TestFiles: none");
            return;
        }
        boolean tmpFirst = true;
        for (TestCase tmpTestCase : tmpTestCases) {
            if (tmpFirst) {
                this.print("TestFiles:  '");
                this.print(tmpTestCase.getName());
                this.print("' (");
                this.print(FilenameUtils.normalize((String)tmpTestCase.getFile().getAbsolutePath()));
                this.println(")");
                tmpFirst = false;
                this.output.indent().indent().indent().indent().indent().indent();
                continue;
            }
            this.print("'");
            this.print(tmpTestCase.getName());
            this.print("' (");
            this.print(FilenameUtils.normalize((String)tmpTestCase.getFile().getAbsolutePath()));
            this.println(")");
        }
    }

    @Override
    public void testCaseStart(TestCase aTestCase) {
        ++this.testCaseCountProcessed;
        this.println("TestCase: '" + aTestCase.getName() + "' (" + this.testCaseCountProcessed + "/" + this.testCaseCountTotal + ")");
    }

    @Override
    public void testRunStart(String aBrowserName) {
        ++this.testCountProcessed;
        this.testResult = TestResult.SUCCESS;
        this.output.indent();
        this.println(aBrowserName);
        this.dotCount = 1;
    }

    @Override
    public void testFileStart(String aFileName) {
    }

    @Override
    public void executeCommandStart(WetatorContext aContext, Command aCommand) {
    }

    @Override
    public void executeCommandSuccess() {
        ++this.stepCountTotal;
        this.printProgressSign(".");
    }

    @Override
    public void executeCommandIgnored() {
        ++this.stepCountTotal;
        ++this.stepCountIgnore;
        this.printProgressSign("i");
    }

    @Override
    public void executeCommandFailure(AssertionException anAssertionException) {
        ++this.stepCountTotal;
        ++this.stepCountFailure;
        if (TestResult.ERROR != this.testResult) {
            this.testResult = TestResult.FAILURE;
        }
        this.printProgressSign("F");
    }

    @Override
    public void executeCommandError(Throwable aThrowable) {
        ++this.stepCountTotal;
        ++this.stepCountError;
        this.testResult = TestResult.ERROR;
        this.printProgressSign("E");
    }

    @Override
    public void executeCommandEnd() {
    }

    @Override
    public void testFileEnd() {
    }

    @Override
    public void testRunIgnored() {
        ++this.testCountIgnored;
    }

    @Override
    public void testRunEnd() {
        this.println("");
        this.output.unindent();
        switch (this.testResult) {
            case ERROR: {
                ++this.testCountError;
                break;
            }
            case FAILURE: {
                ++this.testCountFailure;
                break;
            }
        }
    }

    @Override
    public void testCaseEnd() {
    }

    @Override
    public void end(WetatorEngine aWetatorEngine) {
        this.println("");
        int tmpUnsuccessfulTestCount = this.testCountError + this.testCountFailure + this.testCountIgnored;
        if (tmpUnsuccessfulTestCount > 0) {
            this.println("Failure");
            this.println("  " + tmpUnsuccessfulTestCount + " unsuccessful Test" + (tmpUnsuccessfulTestCount > 1 ? "s" : ""));
            this.println("");
        } else {
            this.println("Success");
        }
        this.println("  Tests: " + this.testCountProcessed + ",  Errors: " + this.testCountError + ",  Failures: " + this.testCountFailure + ",  Ignored: " + this.testCountIgnored);
        this.println("  Steps: " + this.stepCountTotal + ",  Errors: " + this.stepCountError + ",  Failures: " + this.stepCountFailure + ",  Ignored: " + this.stepCountIgnore);
    }

    @Override
    public void responseStored(String aResponseFileName) {
    }

    @Override
    public void highlightedResponse(String aResponseFileName) {
    }

    @Override
    public void error(Throwable aThrowable) {
        this.testResult = TestResult.ERROR;
        aThrowable.printStackTrace();
    }

    @Override
    public void warn(String aMessageKey, Object[] aParameters, String aDetails) {
    }

    @Override
    public void info(String aMessageKey, Object ... aParameters) {
    }

    @Override
    public void htmlDescribe(String aHtmlDescription) {
    }

    public long getTestCountProcessed() {
        return this.testCountProcessed;
    }

    public long getTestCountError() {
        return this.testCountError;
    }

    public long getTestCountFailure() {
        return this.testCountFailure;
    }

    public long getTestCountIgnored() {
        return this.testCountIgnored;
    }

    protected void println(String aString) {
        try {
            this.output.println(aString);
            this.output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void print(String aString) {
        try {
            this.output.print(aString);
            this.output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void printProgressSign(String aProgressSign) {
        if (this.dotCount == 100) {
            this.println(aProgressSign);
            this.dotCount = 1;
            return;
        }
        this.print(aProgressSign);
        ++this.dotCount;
    }

    private static enum TestResult {
        SUCCESS,
        ERROR,
        FAILURE;

    }
}

