/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.progresslistener;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.wetator.core.Command;
import org.wetator.core.IProgressListener;
import org.wetator.core.Parameter;
import org.wetator.core.TestCase;
import org.wetator.core.WetatorConfiguration;
import org.wetator.core.WetatorContext;
import org.wetator.core.WetatorEngine;
import org.wetator.exception.AssertionException;
import org.wetator.util.Output;

public class Log4jProgressListener
extends AbstractAppender
implements IProgressListener {
    private static final Logger LOG = LogManager.getLogger(Log4jProgressListener.class);
    private int commandCount;
    private List<CommandEvents> commandEvents = new LinkedList<CommandEvents>();
    private CommandEvents currentEvents;
    private File outputDir;
    private String testCase;
    private String browser;

    public Log4jProgressListener(int aCommandCount) {
        super("WetatorLog4jProgressListener", null, (Layout)PatternLayout.newBuilder().withPattern("%5p [%5.5t] (%25.25F:%5.5L) - %m%n").build(), true, Property.EMPTY_ARRAY);
        this.commandCount = aCommandCount;
        Command tmpCommand = new Command("--startup--", false);
        this.currentEvents = new CommandEvents(tmpCommand);
        this.start();
        this.addAsTraceAppender();
    }

    protected void addAsTraceAppender() {
        LoggerContext tmpContext = (LoggerContext)LogManager.getContext((boolean)false);
        this.addAsTraceAppender(tmpContext, "org.apache.http.wire");
        this.addAsTraceAppender(tmpContext, "org.wetator");
    }

    protected void addAsTraceAppender(LoggerContext aContext, String aLoggerName) {
        LoggerConfig tmpLogger = aContext.getConfiguration().getLoggerConfig(aLoggerName);
        tmpLogger.setLevel(Level.TRACE);
        tmpLogger.addAppender((Appender)this, null, null);
    }

    public void append(LogEvent aLogEvent) {
        aLogEvent.getSource();
        this.currentEvents.getEvents().add(aLogEvent);
    }

    @Override
    public void init(WetatorEngine aWetatorEngine) {
        WetatorConfiguration tmpConfiguration = aWetatorEngine.getConfiguration();
        this.outputDir = tmpConfiguration.getOutputDir();
    }

    @Override
    public void start(WetatorEngine aWetatorEngine) {
    }

    @Override
    public void testCaseStart(TestCase aTestCase) {
        this.testCase = aTestCase.getName();
    }

    @Override
    public void testRunStart(String aBrowserName) {
        this.browser = aBrowserName;
        this.commandEvents.clear();
    }

    @Override
    public void testFileStart(String aFileName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommandStart(WetatorContext aContext, Command aCommand) {
        if (aCommand.isComment()) {
            return;
        }
        List<CommandEvents> list = this.commandEvents;
        synchronized (list) {
            if (this.commandEvents.size() == this.commandCount) {
                this.commandEvents.remove(0);
            }
            this.currentEvents = new CommandEvents(aCommand);
            this.commandEvents.add(this.currentEvents);
        }
    }

    @Override
    public void executeCommandSuccess() {
    }

    @Override
    public void executeCommandIgnored() {
    }

    @Override
    public void executeCommandFailure(AssertionException anAssertionException) {
        this.dump();
    }

    @Override
    public void executeCommandError(Throwable aThrowable) {
        this.dump();
    }

    @Override
    public void executeCommandEnd() {
    }

    @Override
    public void testFileEnd() {
    }

    @Override
    public void testRunIgnored() {
    }

    @Override
    public void testRunEnd() {
    }

    @Override
    public void testCaseEnd() {
    }

    @Override
    public void end(WetatorEngine aWetatorEngine) {
    }

    @Override
    public void htmlDescribe(String aHtmlDescription) {
    }

    @Override
    public void responseStored(String aResponseFileName) {
    }

    @Override
    public void highlightedResponse(String aResponseFileName) {
    }

    @Override
    public void error(Throwable aThrowable) {
        aThrowable.printStackTrace();
    }

    @Override
    public void warn(String aMessageKey, Object[] aParameters, String aDetails) {
    }

    @Override
    public void info(String aMessageKey, Object ... aParameters) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump() {
        File tmpResultFile;
        String tmpFileName = StringUtils.replace((String)this.testCase, (String)File.separator, (String)"__");
        tmpFileName = "wire_" + tmpFileName + "_" + this.browser;
        String tmpSuffix = "";
        int tmpCount = 0;
        do {
            tmpResultFile = new File(this.outputDir, tmpFileName + tmpSuffix + ".txt");
            tmpSuffix = "_" + tmpCount++;
        } while (tmpResultFile.exists());
        try (FileWriterWithEncoding tmpWriter = new FileWriterWithEncoding(tmpResultFile, StandardCharsets.UTF_8);){
            Output tmpOutput = new Output((Writer)tmpWriter, "    ");
            Layout tmpLayout = this.getLayout();
            for (CommandEvents tmpEvents : this.commandEvents) {
                tmpOutput.println("******************************************");
                tmpOutput.print("* ");
                tmpOutput.println(tmpEvents.getCommand().getName());
                Parameter tmpParam = tmpEvents.getCommand().getFirstParameter();
                if (null != tmpParam) {
                    tmpOutput.print("*   ");
                    tmpOutput.println(tmpParam.getValue());
                }
                if (null != (tmpParam = tmpEvents.getCommand().getSecondParameter())) {
                    tmpOutput.print("*   ");
                    tmpOutput.println(tmpParam.getValue());
                }
                tmpOutput.println("******************************************");
                tmpOutput.indent();
                for (LogEvent tmpEvent : tmpEvents.getEvents()) {
                    if (tmpLayout == null) {
                        tmpOutput.println(tmpEvent.getMessage().toString());
                        continue;
                    }
                    tmpOutput.printStringWithNewLine(tmpLayout.toSerializable(tmpEvent).toString());
                }
                tmpOutput.unindent();
            }
            tmpOutput.flush();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.commandEvents.clear();
        }
    }

    private static final class CommandEvents {
        private Command command;
        private List<LogEvent> events = new LinkedList<LogEvent>();

        private CommandEvents(Command aCommand) {
            this.command = aCommand;
        }

        private Command getCommand() {
            return this.command;
        }

        private List<LogEvent> getEvents() {
            return this.events;
        }
    }
}

