/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core.searchpattern;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wetator.core.searchpattern.MatchAllSearchPattern;
import org.wetator.core.searchpattern.RegExpSearchPattern;
import org.wetator.core.searchpattern.TextOnlySearchPattern;
import org.wetator.util.FindSpot;
import org.wetator.util.SecretString;

public abstract class SearchPattern {
    private static final String SPECIAL_CHARS = "(){}[]|&~+^-.#@\"<>";
    private static SearchPatternCache searchPatternCache = new SearchPatternCache(500);
    private String originalString;

    public static String getStatistics() {
        return searchPatternCache.getStatistics();
    }

    public static SearchPattern createFromList(List<SecretString> aSearch, int aNumberOfElements) {
        StringBuilder tmpPattern = new StringBuilder();
        for (int i = 0; i < aNumberOfElements; ++i) {
            String tmpExpectedString = aSearch.get(i).getValue();
            if (i > 0) {
                tmpPattern.append('*');
            }
            tmpPattern.append(tmpExpectedString);
        }
        return SearchPattern.compile(tmpPattern.toString());
    }

    public static SearchPattern createFromList(List<SecretString> aSearch) {
        return SearchPattern.createFromList(aSearch, aSearch.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchPattern compile(String aDosStyleWildcardString) {
        SearchPattern tmpSearchPattern;
        String tmpDosStyleWildcardString = "";
        if (null != aDosStyleWildcardString) {
            tmpDosStyleWildcardString = aDosStyleWildcardString;
        }
        if ((tmpSearchPattern = searchPatternCache.get(tmpDosStyleWildcardString)) != null) {
            return tmpSearchPattern;
        }
        SearchPatternCache searchPatternCache = SearchPattern.searchPatternCache;
        synchronized (searchPatternCache) {
            tmpSearchPattern = SearchPattern.searchPatternCache.get(tmpDosStyleWildcardString);
            if (tmpSearchPattern != null) {
                return tmpSearchPattern;
            }
            String tmpOriginalString = tmpDosStyleWildcardString;
            StringBuilder tmpPattern = new StringBuilder();
            StringBuilder tmpTextPattern = new StringBuilder();
            boolean tmpSlash = false;
            boolean tmpIsStarPattern = true;
            boolean tmpIsTextOnly = true;
            for (int i = 0; i < tmpDosStyleWildcardString.length(); ++i) {
                char tmpChar = tmpDosStyleWildcardString.charAt(i);
                if ('*' == tmpChar) {
                    if (tmpSlash) {
                        tmpPattern.append("\\*");
                        tmpTextPattern.append('*');
                        tmpSlash = false;
                        continue;
                    }
                    tmpPattern.append(".*");
                    tmpIsTextOnly = false;
                    continue;
                }
                if ('?' == tmpChar) {
                    tmpIsStarPattern = false;
                    if (tmpSlash) {
                        tmpPattern.append("\\?");
                        tmpTextPattern.append('?');
                        tmpSlash = false;
                        continue;
                    }
                    tmpPattern.append('.');
                    tmpIsTextOnly = false;
                    continue;
                }
                if (SPECIAL_CHARS.indexOf(tmpChar) > -1) {
                    tmpIsStarPattern = false;
                    if (tmpSlash) {
                        tmpPattern.append("\\\\\\");
                        tmpPattern.append(tmpChar);
                        tmpTextPattern.append('\\');
                        tmpTextPattern.append(tmpChar);
                        tmpSlash = false;
                        continue;
                    }
                    tmpPattern.append('\\');
                    tmpPattern.append(tmpChar);
                    tmpTextPattern.append(tmpChar);
                    continue;
                }
                if ('\\' == tmpChar) {
                    tmpIsStarPattern = false;
                    tmpSlash = true;
                    continue;
                }
                tmpIsStarPattern = false;
                if (tmpSlash) {
                    tmpPattern.append("\\\\");
                    tmpTextPattern.append('\\');
                    tmpSlash = false;
                }
                tmpPattern.append(tmpChar);
                tmpTextPattern.append(tmpChar);
            }
            if (tmpSlash) {
                tmpPattern.append("\\\\");
                tmpTextPattern.append('\\');
            }
            tmpSearchPattern = tmpIsStarPattern ? new MatchAllSearchPattern() : (tmpIsTextOnly ? new TextOnlySearchPattern(tmpOriginalString, tmpTextPattern.toString()) : new RegExpSearchPattern(tmpOriginalString, tmpPattern.toString()));
            SearchPattern.searchPatternCache.put(aDosStyleWildcardString, tmpSearchPattern);
        }
        return tmpSearchPattern;
    }

    protected SearchPattern(String anOriginalString) {
        this.originalString = anOriginalString;
    }

    public abstract int getMinLength();

    public abstract boolean matches(String var1);

    public abstract boolean matchesAtEnd(String var1);

    public abstract FindSpot firstOccurenceIn(String var1);

    public abstract FindSpot firstOccurenceIn(String var1, int var2);

    public abstract FindSpot lastOccurenceIn(String var1);

    public abstract int noOfCharsBeforeLastOccurenceIn(String var1);

    public abstract int noOfCharsBeforeLastShortestOccurenceIn(String var1);

    public abstract int noOfCharsAfterLastOccurenceIn(String var1);

    public abstract int noOfCharsAfterLastShortestOccurenceIn(String var1);

    public abstract int noOfSurroundingCharsIn(String var1);

    public String getOriginalString() {
        return this.originalString;
    }

    public int hashCode() {
        int tmpPrime = 31;
        int tmpResult = 1;
        tmpResult = 31 * tmpResult;
        if (this.originalString != null) {
            tmpResult += this.originalString.hashCode();
        }
        return tmpResult;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        if (this.getClass() != anObject.getClass()) {
            return false;
        }
        SearchPattern tmpOther = (SearchPattern)anObject;
        return !(this.originalString == null ? tmpOther.originalString != null : !this.originalString.equals(tmpOther.originalString));
    }

    private static class SearchPatternCache {
        private Map<String, SearchPattern> cache;
        private int hitsCount;

        SearchPatternCache(int anInitialSize) {
            this.cache = new HashMap<String, SearchPattern>(anInitialSize);
        }

        public synchronized SearchPattern get(String aDosStyleWildcardString) {
            SearchPattern tmpPattern = this.cache.get(aDosStyleWildcardString);
            if (null != tmpPattern) {
                ++this.hitsCount;
            }
            return tmpPattern;
        }

        public synchronized void put(String aDosStyleWildcardString, SearchPattern aSearchPattern) {
            this.cache.put(aDosStyleWildcardString, aSearchPattern);
        }

        public synchronized String getStatistics() {
            StringBuilder tmpResult = new StringBuilder(80).append("SearchPatternCache statistics:\n").append("      Entries: ").append(this.cache.size()).append('\n').append("      Hits:    ").append(this.hitsCount);
            return tmpResult.toString();
        }
    }
}

