/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core.searchpattern;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import org.apache.commons.lang3.StringUtils;
import org.wetator.core.searchpattern.AutomatonFromEndMatcher;
import org.wetator.core.searchpattern.AutomatonShortFromEndMatcher;
import org.wetator.core.searchpattern.AutomatonShortMatcher;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

final class RegExpSearchPattern
extends SearchPattern {
    private static long constructor;
    private static long noOfCharsBeforeLastOccurenceIn;
    private static long noOfCharsBeforeLastShortestOccurenceIn;
    private static long noOfCharsAfterLastOccurenceIn;
    private static long noOfCharsAfterLastShortestOccurenceIn;
    private static long matches;
    private static long noOfSurroundingCharsIn;
    private static long matchesAtEnd;
    private static long firstOccurenceIn;
    private static long lastOccurenceIn;
    private String patternString;
    private RunAutomaton runAutomaton;
    private int minLength;

    protected RegExpSearchPattern(String anOriginalString, String aPatternString) {
        super(anOriginalString);
        this.patternString = aPatternString;
        Automaton tmpAutomaton = new RegExp(this.patternString).toAutomaton();
        this.minLength = tmpAutomaton.getShortestExample(true).length();
        this.runAutomaton = new RunAutomaton(tmpAutomaton);
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public boolean matches(String aString) {
        ++matches;
        if (null == aString) {
            return false;
        }
        if (aString.length() < this.minLength) {
            return false;
        }
        return this.runAutomaton.run(aString);
    }

    @Override
    public boolean matchesAtEnd(String aString) {
        ++matchesAtEnd;
        if (StringUtils.isEmpty((CharSequence)aString)) {
            return false;
        }
        if (aString.length() < this.minLength) {
            return false;
        }
        AutomatonFromEndMatcher tmpMatcher = new AutomatonFromEndMatcher(aString, this.minLength, this.runAutomaton);
        if (!tmpMatcher.find()) {
            return false;
        }
        return tmpMatcher.end() == aString.length();
    }

    @Override
    public FindSpot firstOccurenceIn(String aString) {
        return this.firstOccurenceIn(aString, 0);
    }

    @Override
    public FindSpot firstOccurenceIn(String aString, int aStartPos) {
        ++firstOccurenceIn;
        if (StringUtils.isEmpty((CharSequence)aString)) {
            return FindSpot.NOT_FOUND;
        }
        if (aString.length() < this.minLength) {
            return FindSpot.NOT_FOUND;
        }
        AutomatonShortMatcher tmpMatcher = new AutomatonShortMatcher(aString, aStartPos, this.runAutomaton);
        boolean tmpFound = tmpMatcher.find();
        if (!tmpFound) {
            return FindSpot.NOT_FOUND;
        }
        return new FindSpot(tmpMatcher.start(), tmpMatcher.end());
    }

    @Override
    public FindSpot lastOccurenceIn(String aString) {
        ++lastOccurenceIn;
        if (StringUtils.isEmpty((CharSequence)aString)) {
            return FindSpot.NOT_FOUND;
        }
        if (aString.length() < this.minLength) {
            return null;
        }
        AutomatonShortFromEndMatcher tmpMatcher = new AutomatonShortFromEndMatcher(aString, this.runAutomaton);
        boolean tmpFound = tmpMatcher.find();
        if (!tmpFound) {
            return null;
        }
        return new FindSpot(tmpMatcher.start(), tmpMatcher.end());
    }

    @Override
    public int noOfCharsBeforeLastOccurenceIn(String aString) {
        ++noOfCharsBeforeLastOccurenceIn;
        int tmpResult = -1;
        if (StringUtils.isEmpty((CharSequence)aString)) {
            return tmpResult;
        }
        if (aString.length() < this.minLength) {
            return -1;
        }
        AutomatonFromEndMatcher tmpMatcher = new AutomatonFromEndMatcher(aString, this.runAutomaton);
        boolean tmpFound = tmpMatcher.find();
        if (!tmpFound) {
            return -1;
        }
        tmpResult = tmpMatcher.start();
        return tmpResult;
    }

    @Override
    public int noOfCharsBeforeLastShortestOccurenceIn(String aString) {
        ++noOfCharsBeforeLastShortestOccurenceIn;
        int tmpResult = -1;
        if (StringUtils.isEmpty((CharSequence)aString)) {
            return tmpResult;
        }
        if (aString.length() < this.minLength) {
            return -1;
        }
        AutomatonShortFromEndMatcher tmpMatcher = new AutomatonShortFromEndMatcher(aString, this.runAutomaton);
        boolean tmpFound = tmpMatcher.find();
        if (!tmpFound) {
            return -1;
        }
        tmpResult = tmpMatcher.start();
        return tmpResult;
    }

    @Override
    public int noOfCharsAfterLastOccurenceIn(String aString) {
        ++noOfCharsAfterLastOccurenceIn;
        int tmpResult = -1;
        if (StringUtils.isEmpty((CharSequence)aString)) {
            return tmpResult;
        }
        if (aString.length() < this.minLength) {
            return -1;
        }
        AutomatonFromEndMatcher tmpMatcher = new AutomatonFromEndMatcher(aString, this.runAutomaton);
        boolean tmpFound = tmpMatcher.find();
        if (!tmpFound) {
            return -1;
        }
        tmpResult = aString.length() - tmpMatcher.end();
        return tmpResult;
    }

    @Override
    public int noOfCharsAfterLastShortestOccurenceIn(String aString) {
        ++noOfCharsAfterLastShortestOccurenceIn;
        int tmpResult = -1;
        if (StringUtils.isEmpty((CharSequence)aString)) {
            return tmpResult;
        }
        if (aString.length() < this.minLength) {
            return -1;
        }
        AutomatonShortFromEndMatcher tmpMatcher = new AutomatonShortFromEndMatcher(aString, this.runAutomaton);
        boolean tmpFound = tmpMatcher.find();
        if (!tmpFound) {
            return -1;
        }
        tmpResult = aString.length() - tmpMatcher.end();
        return tmpResult;
    }

    @Override
    public int noOfSurroundingCharsIn(String aString) {
        ++noOfSurroundingCharsIn;
        if (null == aString) {
            return -1;
        }
        AutomatonMatcher tmpMatcher = this.runAutomaton.newMatcher(aString);
        boolean tmpFound = tmpMatcher.find();
        if (!tmpFound) {
            return -1;
        }
        int tmpResult = Integer.MAX_VALUE;
        while (tmpFound) {
            tmpResult = Math.min(tmpResult, aString.length() - tmpMatcher.group().length());
            tmpFound = tmpMatcher.find();
        }
        return tmpResult;
    }

    public static void dumpStatistics() {
        System.out.println("constructor: " + constructor);
        System.out.println("matches: " + matches);
        System.out.println("matchesAtEnd: " + matchesAtEnd);
        System.out.println();
        System.out.println("firstOccurenceIn: " + firstOccurenceIn);
        System.out.println("lastOccurenceIn: " + lastOccurenceIn);
        System.out.println();
        System.out.println("noOfCharsBeforeLastOccurenceIn: " + noOfCharsBeforeLastOccurenceIn);
        System.out.println("noOfCharsBeforeLastShortestOccurenceIn: " + noOfCharsBeforeLastShortestOccurenceIn);
        System.out.println("noOfCharsAfterLastOccurenceIn: " + noOfCharsAfterLastOccurenceIn);
        System.out.println("noOfCharsAfterLastShortestOccurenceIn: " + noOfCharsAfterLastShortestOccurenceIn);
        System.out.println("noOfSurroundingCharsIn: " + noOfSurroundingCharsIn);
    }

    public String toString() {
        return "SearchPattern '" + this.getOriginalString() + "' [regexp: '" + this.patternString + "']";
    }
}

