/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core.searchpattern;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.exception.AssertionException;
import org.wetator.exception.InvalidInputException;
import org.wetator.i18n.Messages;
import org.wetator.util.Assert;
import org.wetator.util.FindSpot;
import org.wetator.util.SecretString;

public class ContentPattern
implements Serializable {
    private static final long serialVersionUID = 5899557205235216632L;
    public static final String DELIMITER = ",";
    private static final String NOT_OPERTOR = "~";
    private static final String ESCAPE_CHAR = "\\";
    private SecretString rawNode;
    private List<PatternNode> nodes;
    private List<List<PatternNode>> checks;

    public ContentPattern(SecretString anExpectedNodes) throws InvalidInputException {
        this.rawNode = anExpectedNodes;
        if (anExpectedNodes == null || anExpectedNodes.isEmpty()) {
            String tmpMessage = Messages.getMessage("invalidContentPattern", "", Messages.getMessage("emptyContentPattern", new Object[0]));
            throw new InvalidInputException(tmpMessage);
        }
        this.parseNodes();
        this.checks = new LinkedList<List<PatternNode>>();
        this.constructChecks(0, new LinkedList<PatternNode>());
        if (this.checks.get(0).isEmpty()) {
            String tmpMessage = Messages.getMessage("invalidContentPattern", this.toString(), Messages.getMessage("onlyNegatedContentPattern", this.toString()));
            throw new InvalidInputException(tmpMessage);
        }
    }

    private void parseNodes() {
        List<SecretString> tmpParts = this.rawNode.split(DELIMITER, 92);
        this.nodes = new LinkedList<PatternNode>();
        for (SecretString tmpNode : tmpParts) {
            this.nodes.add(new PatternNode(tmpNode.trim()));
        }
    }

    private void constructChecks(int aPos, List<PatternNode> aNodes) {
        if (aPos >= this.nodes.size()) {
            this.checks.add(aNodes);
            return;
        }
        PatternNode tmpNode = this.nodes.get(aPos);
        if (tmpNode.isNegated()) {
            LinkedList<PatternNode> tmpNodes = new LinkedList<PatternNode>();
            tmpNodes.addAll(aNodes);
            this.constructChecks(aPos + 1, tmpNodes);
        }
        aNodes.add(tmpNode);
        this.constructChecks(aPos + 1, aNodes);
    }

    public void matches(String aContent, int aMaxLength) throws AssertionException {
        List<PatternNode> tmpNodes = this.checks.get(0);
        this.privateMatches(tmpNodes, aContent, aMaxLength);
        for (int i = this.checks.size() - 1; i > 0; --i) {
            this.privateMatchesNegated(this.checks.get(i), aContent, aMaxLength);
        }
    }

    private void privateMatches(List<PatternNode> aNodes, String aContent, int aMaxLength) throws AssertionException {
        int tmpStartPos = 0;
        boolean tmpFailed = false;
        StringBuilder tmpResultMessage = new StringBuilder();
        String tmpContent = aContent;
        for (PatternNode tmpNode : this.nodes) {
            if (tmpResultMessage.length() > 0) {
                tmpResultMessage.append(DELIMITER).append(' ');
            }
            String tmpExpectedString = this.buildExpectedStringOutput(tmpNode.toString());
            if (!aNodes.contains(tmpNode)) {
                tmpResultMessage.append(tmpExpectedString);
                continue;
            }
            String tmpExpectedValue = tmpNode.getValue();
            SearchPattern tmpPattern = SearchPattern.compile(tmpExpectedValue);
            FindSpot tmpFoundSpot = tmpPattern.firstOccurenceIn(tmpContent = tmpContent.substring(tmpStartPos));
            if (null == tmpFoundSpot || FindSpot.NOT_FOUND == tmpFoundSpot) {
                tmpFailed = true;
                FindSpot tmpWholeContentFoundSpot = tmpPattern.firstOccurenceIn(aContent);
                if (null == tmpWholeContentFoundSpot || FindSpot.NOT_FOUND == tmpWholeContentFoundSpot) {
                    tmpResultMessage.append('{');
                    tmpResultMessage.append(tmpExpectedString);
                    tmpResultMessage.append('}');
                } else {
                    tmpResultMessage.append('[');
                    tmpResultMessage.append(tmpExpectedString);
                    tmpResultMessage.append(']');
                }
                tmpStartPos = 0;
                continue;
            }
            tmpResultMessage.append(tmpExpectedString);
            tmpStartPos = tmpFoundSpot.getEndPos();
        }
        if (tmpFailed) {
            tmpContent = StringUtils.abbreviate((String)aContent, (int)aMaxLength);
            Assert.fail("contentsFailed", "{", "}", "[", "]", tmpResultMessage.toString(), tmpContent);
        }
    }

    private String buildExpectedStringOutput(String anExpectedString) {
        String tmpResult = StringUtils.replace((String)anExpectedString, (String)" ", (String)"\u2423");
        tmpResult = StringUtils.replace((String)tmpResult, (String)"\t", (String)"\u2423");
        return tmpResult;
    }

    private void privateMatchesNegated(List<PatternNode> aNodes, String aContent, int aMaxLength) throws AssertionException {
        int tmpStartPos = 0;
        StringBuilder tmpResultMessage = new StringBuilder();
        String tmpContent = aContent;
        for (PatternNode tmpNode : this.nodes) {
            if (tmpResultMessage.length() > 0) {
                tmpResultMessage.append(DELIMITER).append(' ');
            }
            String tmpExpectedString = tmpNode.toString();
            if (!aNodes.contains(tmpNode)) {
                tmpResultMessage.append(tmpExpectedString);
                continue;
            }
            String tmpExpectedValue = tmpNode.getValue();
            SearchPattern tmpPattern = SearchPattern.compile(tmpExpectedValue);
            FindSpot tmpFoundSpot = tmpPattern.firstOccurenceIn(tmpContent = tmpContent.substring(tmpStartPos));
            if (null == tmpFoundSpot || FindSpot.NOT_FOUND == tmpFoundSpot) {
                return;
            }
            if (tmpNode.isNegated()) {
                tmpResultMessage.append('{');
                tmpResultMessage.append(tmpExpectedString);
                tmpResultMessage.append('}');
            } else {
                tmpResultMessage.append(tmpExpectedString);
            }
            tmpStartPos = tmpFoundSpot.getEndPos();
        }
        tmpContent = StringUtils.abbreviate((String)aContent, (int)aMaxLength);
        Assert.fail("contentsFoundButNegated", "{", "}", tmpResultMessage.toString(), tmpContent);
    }

    public String toString() {
        return this.rawNode.toString();
    }

    static final class PatternNode
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 1208708219806742182L;
        private SecretString value;
        private boolean negated;
        private boolean negatedEscaped;

        PatternNode(SecretString aNode) {
            String tmpValue = aNode.getValue();
            if (tmpValue.startsWith(ContentPattern.NOT_OPERTOR)) {
                this.negated = true;
                this.value = aNode.substring(1);
            } else if (tmpValue.startsWith("\\~")) {
                this.negatedEscaped = true;
                this.value = aNode.substring(1);
            } else {
                this.value = aNode;
            }
        }

        public String getValue() {
            return this.value.getValue();
        }

        public boolean isNegated() {
            return this.negated;
        }

        public String toString() {
            if (this.negated) {
                return ContentPattern.NOT_OPERTOR + this.value.toString();
            }
            if (this.negatedEscaped) {
                return ContentPattern.ESCAPE_CHAR + this.value.toString();
            }
            return this.value.toString();
        }

        public PatternNode clone() {
            try {
                return (PatternNode)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

