/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.core;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.IBrowser;
import org.wetator.backend.htmlunit.HtmlUnitBrowser;
import org.wetator.core.Command;
import org.wetator.core.ICommandImplementation;
import org.wetator.core.ICommandSet;
import org.wetator.core.IProgressListener;
import org.wetator.core.IScripter;
import org.wetator.core.TestCase;
import org.wetator.core.WetatorConfiguration;
import org.wetator.core.WetatorContext;
import org.wetator.exception.AssertionException;
import org.wetator.exception.InvalidInputException;
import org.wetator.progresslistener.XMLResultWriter;

public class WetatorEngine {
    private static final Logger LOG = LogManager.getLogger(WetatorEngine.class);
    private static final String PROPERTY_TEST_CONFIG = "wetator.config";
    private static final String CONFIG_FILE_DEFAULT_NAME = "wetator.config";
    private static final String PROPERTY_TEST_VARIABLES = "wetator.variables";
    private static final String VARIABLES_FILE_DEFAULT_NAME = "wetator.variables";
    private String configFileName;
    private String variablesFileName;
    private Map<String, String> externalProperties;
    private List<TestCase> testCases = new LinkedList<TestCase>();
    private WetatorConfiguration configuration;
    private IBrowser browser;
    private List<ICommandSet> commandSets;
    private List<IScripter> scripter;
    private List<IProgressListener> progressListener = new LinkedList<IProgressListener>();

    public void init() {
        this.init(this.readConfiguration());
    }

    public void init(WetatorConfiguration aConfiguration) {
        this.informListenersInit();
        this.configuration = aConfiguration;
        if (this.configFileName == null) {
            this.configFileName = "";
        }
        if (this.variablesFileName == null) {
            this.variablesFileName = "";
        }
        this.scripter = this.getConfiguration().getScripters();
        this.commandSets = this.getConfiguration().getCommandSets();
    }

    private WetatorConfiguration readConfiguration() {
        File tmpConfigFile = this.getConfigFile();
        File tmpVariablesFile = this.getVariablesFile();
        return new WetatorConfiguration(tmpConfigFile, tmpVariablesFile, this.getExternalProperties());
    }

    protected IBrowser createBrowser() {
        return new HtmlUnitBrowser(this);
    }

    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    public void addTestCase(String aName, File aFile) throws InvalidInputException {
        if (!aFile.exists()) {
            throw new InvalidInputException("The test file '" + FilenameUtils.normalize((String)aFile.getAbsolutePath()) + "' does not exist.");
        }
        if (!aFile.isFile() || !aFile.canRead()) {
            throw new InvalidInputException("The test file '" + FilenameUtils.normalize((String)aFile.getAbsolutePath()) + "' is not readable.");
        }
        this.testCases.add(new TestCase(aName, aFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTests() {
        IBrowser tmpBrowser = this.createBrowser();
        this.setBrowser(tmpBrowser);
        this.addDefaultProgressListeners();
        this.informListenersStart();
        try {
            boolean tmpTestCaseErrorOccurred = false;
            for (TestCase tmpTestCase : this.getTestCases()) {
                boolean tmpValidInput = true;
                File tmpFile = tmpTestCase.getFile();
                LOG.info("Executing tests from file '" + FilenameUtils.normalize((String)tmpFile.getAbsolutePath()) + "'");
                this.informListenersTestCaseStart(tmpTestCase);
                try {
                    boolean tmpTestRunErrorOccurred = false;
                    for (IBrowser.BrowserType tmpBrowserType : this.getConfiguration().getBrowserTypes()) {
                        this.informListenersTestRunStart(tmpBrowserType.getLabel());
                        try {
                            if (!tmpTestCaseErrorOccurred && !tmpTestRunErrorOccurred && tmpValidInput) {
                                this.getBrowser().startNewSession(tmpBrowserType);
                                try {
                                    WetatorContext tmpWetatorContext = this.createWetatorContext(tmpTestCase, tmpBrowserType);
                                    tmpValidInput = tmpWetatorContext.execute();
                                    if (tmpValidInput) continue;
                                    tmpTestRunErrorOccurred = true;
                                    continue;
                                }
                                finally {
                                    this.getBrowser().endSession();
                                    continue;
                                }
                            }
                            this.informListenersTestRunIgnored();
                        }
                        catch (RuntimeException e) {
                            this.informListenersError(e);
                        }
                        catch (Throwable e) {
                            tmpTestCaseErrorOccurred = true;
                            this.informListenersError(e);
                        }
                        finally {
                            this.informListenersTestRunEnd();
                        }
                    }
                }
                finally {
                    this.informListenersTestCaseEnd();
                }
            }
        }
        finally {
            this.informListenersEnd();
        }
    }

    public void shutdown() {
        IBrowser tmpBrowser = this.getBrowser();
        if (tmpBrowser != null) {
            tmpBrowser.close();
        }
    }

    protected void addDefaultProgressListeners() {
        XMLResultWriter tmpResultWriter = new XMLResultWriter();
        tmpResultWriter.init(this);
        this.addProgressListener(tmpResultWriter);
        if (this.configuration.getRetrospect() > 0) {
            try {
                Class<?> tmpClass = Class.forName("org.wetator.progresslistener.Log4jProgressListener");
                Constructor<?> tmpConstructor = tmpClass.getConstructor(Integer.TYPE);
                IProgressListener tmpProgressListener = (IProgressListener)tmpConstructor.newInstance(this.configuration.getRetrospect());
                tmpProgressListener.init(this);
                this.addProgressListener(tmpProgressListener);
                LOG.info("Retrospect enabled; steps: " + this.configuration.getRetrospect() + ".");
            }
            catch (Throwable e) {
                LOG.error("Could not instanciate Log4jProgressListener. Retrospect is disabled.", e);
            }
        }
    }

    protected WetatorContext createWetatorContext(TestCase aTestCase, IBrowser.BrowserType aBrowserType) {
        return new WetatorContext(this, aTestCase.getName(), aTestCase.getFile(), aBrowserType);
    }

    protected List<Command> readCommandsFromFile(File aFile) throws InvalidInputException {
        IScripter tmpScripter = this.createScripter(aFile);
        tmpScripter.script(aFile);
        return tmpScripter.getCommands();
    }

    private IScripter createScripter(File aFile) throws InvalidInputException {
        LinkedList<IScripter.IsSupportedResult> tmpResults = new LinkedList<IScripter.IsSupportedResult>();
        for (IScripter tmpScripter : this.scripter) {
            IScripter.IsSupportedResult tmpResult = tmpScripter.isSupported(aFile);
            if (IScripter.IS_SUPPORTED == tmpResult) {
                return tmpScripter;
            }
            tmpResults.add(tmpResult);
        }
        StringBuilder tmpMessage = new StringBuilder("No scripter found for file '");
        tmpMessage.append(FilenameUtils.normalize((String)aFile.getAbsolutePath())).append("' (");
        boolean tmpIsFirst = true;
        for (IScripter.IsSupportedResult tmpIsSupportedResult : tmpResults) {
            if (!tmpIsFirst) {
                tmpMessage.append("; ");
            }
            tmpMessage.append(tmpIsSupportedResult.getMessage());
            tmpIsFirst = false;
        }
        tmpMessage.append(").");
        throw new InvalidInputException(tmpMessage.toString());
    }

    protected ICommandImplementation getCommandImplementationFor(String aCommandName) {
        for (ICommandSet tmpCommandSet : this.commandSets) {
            ICommandImplementation tmpCommandImplementation = tmpCommandSet.getCommandImplementationFor(aCommandName);
            if (null == tmpCommandImplementation) continue;
            return tmpCommandImplementation;
        }
        return null;
    }

    public File getConfigFile() {
        String tmpConfigName = this.getConfigFileName();
        if ("".equals(tmpConfigName)) {
            return null;
        }
        if (null == tmpConfigName) {
            tmpConfigName = System.getProperty("wetator.config", "wetator.config");
        }
        return new File(tmpConfigName);
    }

    public File getVariablesFile() {
        String tmpVariablesName = this.getVariablesFileName();
        if (null == tmpVariablesName) {
            tmpVariablesName = System.getProperty("wetator.variables");
        }
        if (null != tmpVariablesName) {
            return new File(tmpVariablesName);
        }
        File tmpVarFile = new File("wetator.variables");
        if (tmpVarFile.exists()) {
            return tmpVarFile;
        }
        return null;
    }

    public IBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(IBrowser aBrowser) {
        this.browser = aBrowser;
    }

    public WetatorConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void setConfigFileName(String aConfigFileName) {
        this.configFileName = aConfigFileName;
    }

    public String getVariablesFileName() {
        return this.variablesFileName;
    }

    public void setVariablesFileName(String aVariablesFileName) {
        this.variablesFileName = aVariablesFileName;
    }

    public Map<String, String> getExternalProperties() {
        return this.externalProperties;
    }

    public void setExternalProperties(Map<String, String> aExternalProperties) {
        this.externalProperties = aExternalProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(IProgressListener aProgressListener) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            if (this.progressListener.contains(aProgressListener)) {
                return;
            }
            this.progressListener.add(aProgressListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersInit() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.init(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersStart() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.start(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersTestCaseStart(TestCase aTestCase) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.testCaseStart(aTestCase);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersTestRunStart(String aBrowserName) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.testRunStart(aBrowserName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersTestFileStart(String aFileName) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.testFileStart(aFileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersExecuteCommandStart(WetatorContext aContext, Command aCommand) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.executeCommandStart(aContext, aCommand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersExecuteCommandEnd() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.executeCommandEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersExecuteCommandSuccess() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.executeCommandSuccess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersExecuteCommandIgnored() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.executeCommandIgnored();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersExecuteCommandFailure(AssertionException anAssertionException) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.executeCommandFailure(anAssertionException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersExecuteCommandError(Throwable aThrowable) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.executeCommandError(aThrowable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersTestFileEnd() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.testFileEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersTestRunIgnored() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.testRunIgnored();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersTestRunEnd() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.testRunEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersTestCaseEnd() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.testCaseEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informListenersEnd() {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.end(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListenersError(Throwable aThrowable) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.error(aThrowable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListenersWarn(String aMessageKey, Object[] aParameters, Throwable aThrowable) {
        String tmpStackTrace = null;
        if (null != aThrowable) {
            tmpStackTrace = ExceptionUtils.getStackTrace((Throwable)aThrowable);
        }
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.warn(aMessageKey, aParameters, tmpStackTrace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListenersWarn(String aMessageKey, Object[] aParameters, String aDetails) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.warn(aMessageKey, aParameters, aDetails);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListenersInfo(String aMessageKey, Object ... aParameters) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.info(aMessageKey, aParameters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListenersHtmlDescribe(String aHtmlDescription) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.htmlDescribe(aHtmlDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListenersResponseStored(String aResponseFileName) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.responseStored(aResponseFileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informListenersHighlightedResponse(String aResponseFileName) {
        List<IProgressListener> list = this.progressListener;
        synchronized (list) {
            for (IProgressListener tmpListener : this.progressListener) {
                tmpListener.highlightedResponse(aResponseFileName);
            }
        }
    }
}

