/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.matcher;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.matcher.AbstractByAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class ByInnerImageMatcher
extends AbstractHtmlUnitElementMatcher {
    public ByInnerImageMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern) {
        super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern);
    }

    @Override
    public List<AbstractHtmlUnitElementMatcher.MatchResult> matches(HtmlElement aHtmlElement) {
        if (FindSpot.NOT_FOUND == this.pathSpot) {
            return Collections.emptyList();
        }
        FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(aHtmlElement);
        if (this.pathSpot == null || this.pathSpot.getEndPos() <= tmpNodeSpot.getStartPos()) {
            LinkedList<AbstractHtmlUnitElementMatcher.MatchResult> tmpMatches = new LinkedList<AbstractHtmlUnitElementMatcher.MatchResult>();
            Iterable tmpInnerElements = aHtmlElement.getHtmlElementDescendants();
            for (HtmlElement tmpInnerElement : tmpInnerElements) {
                if (!(tmpInnerElement instanceof HtmlImage)) continue;
                tmpMatches.addAll(new ByInnerImageAltAttributeMatcher(this.htmlPageIndex, this.pathSearchPattern, this.pathSpot, this.searchPattern, (HtmlImage)tmpInnerElement).matches(aHtmlElement));
                tmpMatches.addAll(new ByInnerImageTitleAttributeMatcher(this.htmlPageIndex, this.pathSearchPattern, this.pathSpot, this.searchPattern, (HtmlImage)tmpInnerElement).matches(aHtmlElement));
                tmpMatches.addAll(new ByInnerImageSrcAttributeMatcher(this.htmlPageIndex, this.pathSearchPattern, this.pathSpot, this.searchPattern, (HtmlImage)tmpInnerElement).matches(aHtmlElement));
                tmpMatches.addAll(new ByInnerImageNameMatcher(this.htmlPageIndex, this.pathSearchPattern, this.pathSpot, this.searchPattern, (HtmlImage)tmpInnerElement).matches(aHtmlElement));
            }
            return tmpMatches;
        }
        return Collections.emptyList();
    }

    protected static class ByInnerImageNameMatcher
    extends AbstractByAttributeMatcher {
        private HtmlImage innerHtmlImage;

        public ByInnerImageNameMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, HtmlImage anInnerHtmlImage) {
            super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern, WeightedControlList.FoundType.BY_INNER_IMG_NAME);
            this.innerHtmlImage = anInnerHtmlImage;
            this.matchType = AbstractByAttributeMatcher.MatchType.EXACT;
        }

        @Override
        protected String getAttributeValue(HtmlElement aHtmlElement) {
            return this.innerHtmlImage.getAttribute("name");
        }
    }

    protected static class ByInnerImageTitleAttributeMatcher
    extends AbstractByAttributeMatcher {
        private HtmlImage innerHtmlImage;

        public ByInnerImageTitleAttributeMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, HtmlImage anInnerHtmlImage) {
            super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern, WeightedControlList.FoundType.BY_INNER_IMG_TITLE_ATTRIBUTE);
            this.innerHtmlImage = anInnerHtmlImage;
        }

        @Override
        protected String getAttributeValue(HtmlElement aHtmlElement) {
            return this.innerHtmlImage.getAttribute("title");
        }
    }

    protected static class ByInnerImageSrcAttributeMatcher
    extends AbstractByAttributeMatcher {
        private HtmlImage innerHtmlImage;

        public ByInnerImageSrcAttributeMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, HtmlImage anInnerHtmlImage) {
            super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern, WeightedControlList.FoundType.BY_INNER_IMG_SRC_ATTRIBUTE);
            this.innerHtmlImage = anInnerHtmlImage;
            this.matchType = AbstractByAttributeMatcher.MatchType.ENDS_WITH;
        }

        @Override
        protected String getAttributeValue(HtmlElement aHtmlElement) {
            return this.innerHtmlImage.getSrcAttribute();
        }
    }

    protected static class ByInnerImageAltAttributeMatcher
    extends AbstractByAttributeMatcher {
        private HtmlImage innerHtmlImage;

        public ByInnerImageAltAttributeMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, HtmlImage anInnerHtmlImage) {
            super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern, WeightedControlList.FoundType.BY_INNER_IMG_ALT_ATTRIBUTE);
            this.innerHtmlImage = anInnerHtmlImage;
        }

        @Override
        protected String getAttributeValue(HtmlElement aHtmlElement) {
            return this.innerHtmlImage.getAltAttribute();
        }
    }
}

