/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control.identifier;

import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import java.util.List;
import org.wetator.backend.WPath;
import org.wetator.backend.control.IControl;
import org.wetator.backend.htmlunit.control.HtmlUnitInputFile;
import org.wetator.backend.htmlunit.control.identifier.AbstractMatcherBasedIdentifier;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.matcher.ByHtmlLabelMatcher;
import org.wetator.backend.htmlunit.matcher.ByIdMatcher;
import org.wetator.backend.htmlunit.matcher.ByLabelingTextBeforeAsTextMatcher;
import org.wetator.backend.htmlunit.matcher.ByLabelingTextBeforeMatcher;
import org.wetator.backend.htmlunit.matcher.ByNameAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.ByTableCoordinatesMatcher;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class HtmlUnitInputFileIdentifier
extends AbstractMatcherBasedIdentifier {
    @Override
    public boolean isHtmlElementSupported(HtmlElement aHtmlElement) {
        return aHtmlElement instanceof HtmlFileInput || aHtmlElement instanceof HtmlLabel && ((HtmlLabel)aHtmlElement).getLabeledElement() instanceof HtmlFileInput;
    }

    @Override
    protected void addMatchers(WPath aWPath, HtmlElement aHtmlElement, List<AbstractHtmlUnitElementMatcher> aMatchers) {
        SearchPattern tmpPathSearchPattern = null;
        FindSpot tmpPathSpot = null;
        if (!aWPath.getPathNodes().isEmpty()) {
            tmpPathSearchPattern = SearchPattern.createFromList(aWPath.getPathNodes());
            tmpPathSpot = this.htmlPageIndex.firstOccurence(tmpPathSearchPattern);
        }
        if (tmpPathSpot == FindSpot.NOT_FOUND) {
            return;
        }
        if (aWPath.getLastNode() != null) {
            SearchPattern tmpSearchPattern = aWPath.getLastNode().getSearchPattern();
            if (aHtmlElement instanceof HtmlFileInput) {
                aMatchers.add(new ByLabelingTextBeforeAsTextMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern, aWPath));
                aMatchers.add(new ByLabelingTextBeforeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
                aMatchers.add(new ByNameAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
                aMatchers.add(new ByIdMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            } else if (aHtmlElement instanceof HtmlLabel) {
                aMatchers.add(new ByHtmlLabelMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern, HtmlFileInput.class));
            }
        } else if (!aWPath.getTableCoordinates().isEmpty()) {
            aMatchers.add(new ByTableCoordinatesMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, aWPath.getTableCoordinatesReversed(), HtmlFileInput.class));
        }
    }

    @Override
    protected IControl createControl(AbstractHtmlUnitElementMatcher.MatchResult aMatch) {
        return new HtmlUnitInputFile((HtmlFileInput)aMatch.getHtmlElement());
    }
}

