/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlUrlInput;
import com.gargoylesoftware.htmlunit.html.Keyboard;
import java.io.File;
import net.sourceforge.htmlunit.corejs.javascript.WrappedException;
import org.wetator.backend.control.IControl;
import org.wetator.backend.control.ISettable;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.IHtmlUnitDisableable;
import org.wetator.backend.htmlunit.control.IHtmlUnitFocusable;
import org.wetator.backend.htmlunit.control.identifier.HtmlUnitInputUrlIdentifier;
import org.wetator.backend.htmlunit.util.ExceptionUtil;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.BackendException;
import org.wetator.i18n.Messages;
import org.wetator.util.Assert;
import org.wetator.util.SecretString;

@HtmlUnitBaseControl.ForHtmlElement(value=HtmlUrlInput.class)
@HtmlUnitBaseControl.IdentifiedBy(value={HtmlUnitInputUrlIdentifier.class})
public class HtmlUnitInputUrl
extends HtmlUnitBaseControl<HtmlUrlInput>
implements ISettable,
IHtmlUnitDisableable<HtmlUrlInput>,
IHtmlUnitFocusable<HtmlUrlInput> {
    public HtmlUnitInputUrl(HtmlUrlInput anHtmlElement) {
        super(anHtmlElement);
    }

    @Override
    public String getDescribingText() {
        return HtmlElementUtil.getDescribingTextForHtmlUrlInput((HtmlUrlInput)this.getHtmlElement());
    }

    @Override
    public void setValue(WetatorContext aWetatorContext, SecretString aValue, File aDirectory) throws ActionException {
        String tmpMessage;
        Exception tmpScriptException;
        HtmlUrlInput tmpHtmlUrlInput = (HtmlUrlInput)this.getHtmlElement();
        if (tmpHtmlUrlInput.isDisabled()) {
            String tmpMessage2 = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage2);
        }
        if (tmpHtmlUrlInput.isReadOnly()) {
            String tmpMessage3 = Messages.getMessage("elementReadOnly", this.getDescribingText());
            throw new ActionException(tmpMessage3);
        }
        try {
            HtmlPage tmpHtmlPage = (HtmlPage)tmpHtmlUrlInput.getPage();
            DomElement tmpFocusedElement = tmpHtmlPage.getFocusedElement();
            if (tmpFocusedElement == null || tmpHtmlUrlInput != tmpFocusedElement) {
                tmpHtmlUrlInput.click();
                aWetatorContext.getBrowser().waitForImmediateJobs(100L);
                tmpFocusedElement = tmpHtmlPage.getFocusedElement();
                if (tmpHtmlUrlInput != tmpFocusedElement) {
                    IControl tmpFocusedControl = aWetatorContext.getBrowser().getFocusedControl();
                    if (tmpFocusedControl == null) {
                        aWetatorContext.informListenersInfo("focusRemoved", this.getDescribingText());
                        throw new ActionException("After clicking on the control '" + this.getDescribingText() + "' the focus was removed.");
                    }
                    String tmpDesc = tmpFocusedControl.getDescribingText();
                    aWetatorContext.informListenersInfo("focusChanged", this.getDescribingText(), tmpDesc);
                    if (tmpFocusedControl instanceof ISettable) {
                        ((ISettable)tmpFocusedControl).setValue(aWetatorContext, aValue, aDirectory);
                        return;
                    }
                    throw new ActionException("Focused control '" + tmpDesc + "' is not settable.");
                }
            }
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            String tmpMessage4 = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage4, e);
        }
        catch (ActionException e) {
            throw e;
        }
        catch (Throwable e) {
            String tmpMessage5 = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage5, e);
        }
        try {
            String tmpValue = aValue.getValue();
            tmpHtmlUrlInput.select();
            if (tmpValue.length() > 0) {
                long tmpDelay = 1000L / (long)(aWetatorContext.getConfiguration().getTypingSpeedInKeystrokesPerMinute() / 60);
                tmpHtmlUrlInput.type(tmpValue.charAt(0));
                for (int i = 1; i < tmpValue.length(); ++i) {
                    aWetatorContext.getBrowser().waitForImmediateJobs(tmpDelay);
                    char tmpChar = tmpValue.charAt(i);
                    tmpHtmlUrlInput.type(tmpChar);
                }
            } else {
                Keyboard tmpKeyboard = new Keyboard();
                tmpKeyboard.press(46);
                tmpHtmlUrlInput.type(tmpKeyboard);
            }
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public void assertValue(WetatorContext aWetatorContext, SecretString anExpectedValue) throws AssertionException {
        Assert.assertEquals(anExpectedValue, ((HtmlUrlInput)this.getHtmlElement()).getValueAttribute(), "expectedValueNotFound", new Object[0]);
    }

    @Override
    public boolean isDisabled(WetatorContext aWetatorContext) {
        HtmlUrlInput tmpHtmlUrlInput = (HtmlUrlInput)this.getHtmlElement();
        return tmpHtmlUrlInput.isDisabled() || tmpHtmlUrlInput.isReadOnly();
    }
}

