/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlNumberInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.Keyboard;
import java.io.File;
import net.sourceforge.htmlunit.corejs.javascript.WrappedException;
import org.wetator.backend.control.IControl;
import org.wetator.backend.control.ISettable;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.IHtmlUnitDisableable;
import org.wetator.backend.htmlunit.control.IHtmlUnitFocusable;
import org.wetator.backend.htmlunit.control.identifier.HtmlUnitInputNumberIdentifier;
import org.wetator.backend.htmlunit.util.ExceptionUtil;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.BackendException;
import org.wetator.i18n.Messages;
import org.wetator.util.Assert;
import org.wetator.util.SecretString;

@HtmlUnitBaseControl.ForHtmlElement(value=HtmlNumberInput.class)
@HtmlUnitBaseControl.IdentifiedBy(value={HtmlUnitInputNumberIdentifier.class})
public class HtmlUnitInputNumber
extends HtmlUnitBaseControl<HtmlNumberInput>
implements ISettable,
IHtmlUnitDisableable<HtmlNumberInput>,
IHtmlUnitFocusable<HtmlNumberInput> {
    public HtmlUnitInputNumber(HtmlNumberInput anHtmlElement) {
        super(anHtmlElement);
    }

    @Override
    public String getDescribingText() {
        return HtmlElementUtil.getDescribingTextForHtmlNumberInput((HtmlNumberInput)this.getHtmlElement());
    }

    @Override
    public void setValue(WetatorContext aWetatorContext, SecretString aValue, File aDirectory) throws ActionException {
        String tmpMessage;
        Exception tmpScriptException;
        HtmlNumberInput tmpHtmlNumberInput = (HtmlNumberInput)this.getHtmlElement();
        if (tmpHtmlNumberInput.isDisabled()) {
            String tmpMessage2 = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage2);
        }
        if (tmpHtmlNumberInput.isReadOnly()) {
            String tmpMessage3 = Messages.getMessage("elementReadOnly", this.getDescribingText());
            throw new ActionException(tmpMessage3);
        }
        try {
            HtmlPage tmpHtmlPage = (HtmlPage)tmpHtmlNumberInput.getPage();
            DomElement tmpFocusedElement = tmpHtmlPage.getFocusedElement();
            if (tmpFocusedElement == null || tmpHtmlNumberInput != tmpFocusedElement) {
                tmpHtmlNumberInput.click();
                aWetatorContext.getBrowser().waitForImmediateJobs(100L);
                tmpFocusedElement = tmpHtmlPage.getFocusedElement();
                if (tmpHtmlNumberInput != tmpFocusedElement) {
                    IControl tmpFocusedControl = aWetatorContext.getBrowser().getFocusedControl();
                    if (tmpFocusedControl == null) {
                        aWetatorContext.informListenersInfo("focusRemoved", this.getDescribingText());
                        throw new ActionException("After clicking on the control '" + this.getDescribingText() + "' the focus was removed.");
                    }
                    String tmpDesc = tmpFocusedControl.getDescribingText();
                    aWetatorContext.informListenersInfo("focusChanged", this.getDescribingText(), tmpDesc);
                    if (tmpFocusedControl instanceof ISettable) {
                        ((ISettable)tmpFocusedControl).setValue(aWetatorContext, aValue, aDirectory);
                        return;
                    }
                    throw new ActionException("Focused control '" + tmpDesc + "' is not settable.");
                }
            }
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            String tmpMessage4 = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage4, e);
        }
        catch (ActionException e) {
            throw e;
        }
        catch (Throwable e) {
            String tmpMessage5 = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage5, e);
        }
        try {
            String tmpValue = aValue.getValue();
            tmpHtmlNumberInput.select();
            if (tmpValue.length() > 0) {
                long tmpDelay = 1000L / (long)(aWetatorContext.getConfiguration().getTypingSpeedInKeystrokesPerMinute() / 60);
                tmpHtmlNumberInput.type(tmpValue.charAt(0));
                for (int i = 1; i < tmpValue.length(); ++i) {
                    aWetatorContext.getBrowser().waitForImmediateJobs(tmpDelay);
                    char tmpChar = tmpValue.charAt(i);
                    tmpHtmlNumberInput.type(tmpChar);
                }
            } else {
                Keyboard tmpKeyboard = new Keyboard();
                tmpKeyboard.press(46);
                tmpHtmlNumberInput.type(tmpKeyboard);
            }
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public void assertValue(WetatorContext aWetatorContext, SecretString anExpectedValue) throws AssertionException {
        Assert.assertEquals(anExpectedValue, ((HtmlNumberInput)this.getHtmlElement()).getValueAttribute(), "expectedValueNotFound", new Object[0]);
    }

    @Override
    public boolean isDisabled(WetatorContext aWetatorContext) {
        HtmlNumberInput tmpHtmlNumberInput = (HtmlNumberInput)this.getHtmlElement();
        return tmpHtmlNumberInput.isDisabled() || tmpHtmlNumberInput.isReadOnly();
    }
}

