/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNamespaceNode;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAbbreviated;
import com.gargoylesoftware.htmlunit.html.HtmlAcronym;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.html.HtmlBig;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBold;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCanvas;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlCitation;
import com.gargoylesoftware.htmlunit.html.HtmlCode;
import com.gargoylesoftware.htmlunit.html.HtmlDefinition;
import com.gargoylesoftware.htmlunit.html.HtmlDeletedText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlEmbed;
import com.gargoylesoftware.htmlunit.html.HtmlEmphasis;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlFont;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrame;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlHeading1;
import com.gargoylesoftware.htmlunit.html.HtmlHeading2;
import com.gargoylesoftware.htmlunit.html.HtmlHeading3;
import com.gargoylesoftware.htmlunit.html.HtmlHeading4;
import com.gargoylesoftware.htmlunit.html.HtmlHeading5;
import com.gargoylesoftware.htmlunit.html.HtmlHeading6;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlHorizontalRule;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInlineQuotation;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlInsertedText;
import com.gargoylesoftware.htmlunit.html.HtmlItalic;
import com.gargoylesoftware.htmlunit.html.HtmlKeyboard;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlParagraph;
import com.gargoylesoftware.htmlunit.html.HtmlParameter;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSample;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSmall;
import com.gargoylesoftware.htmlunit.html.HtmlStrong;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubscript;
import com.gargoylesoftware.htmlunit.html.HtmlSuperscript;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTeletype;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.HtmlUnknownElement;
import com.gargoylesoftware.htmlunit.html.HtmlVariable;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.svg.SvgCircle;
import com.gargoylesoftware.htmlunit.svg.SvgEllipse;
import com.gargoylesoftware.htmlunit.svg.SvgLine;
import com.gargoylesoftware.htmlunit.svg.SvgPath;
import com.gargoylesoftware.htmlunit.svg.SvgPolygon;
import com.gargoylesoftware.htmlunit.svg.SvgPolyline;
import com.gargoylesoftware.htmlunit.svg.SvgRect;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.backend.htmlunit.ResponseStore;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.util.Output;
import org.wetator.util.XMLUtil;

public final class XHtmlOutputter {
    private static final Logger LOG = LogManager.getLogger(XHtmlOutputter.class);
    private static final Set<String> EMPTY_TAGS;
    private static final Set<String> SINGLE_LINE_TAGS;
    private static final Set<String> IGNORED_ATTRIBUTES;
    private static final Map<Class<? extends Object>, String> TAG_NAMES;
    private HtmlPage htmlPage;
    private ResponseStore responseStore;
    private Output output;
    private XMLUtil xmlUtil;

    public XHtmlOutputter(HtmlPage anHtmlPage, ResponseStore aResponseStore) {
        this.htmlPage = anHtmlPage;
        this.responseStore = aResponseStore;
    }

    public void writeTo(File aFile) throws IOException {
        FileWriterWithEncoding tmpFileWriter = new FileWriterWithEncoding(aFile, this.htmlPage.getCharset());
        this.writeTo((Writer)tmpFileWriter);
    }

    public void writeTo(Writer aWriter) throws IOException {
        try {
            this.xmlUtil = new XMLUtil();
            this.output = new Output(aWriter, "  ");
            this.output.println("<?xml version=\"1.0\" encoding=\"" + this.htmlPage.getCharset().name() + "\"?>");
            this.output.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            this.writeSubNodes((DomNode)this.htmlPage, new Context());
        }
        finally {
            this.output.close();
        }
    }

    private void writeSubNodes(DomNode aDomNode, Context aContext) throws IOException {
        for (DomNode tmpChild = aDomNode.getFirstChild(); null != tmpChild; tmpChild = tmpChild.getNextSibling()) {
            if (tmpChild instanceof DomDocumentType || tmpChild instanceof HtmlScript || tmpChild instanceof DomComment || tmpChild instanceof HtmlBase) continue;
            if (tmpChild instanceof HtmlCanvas) {
                this.writeCanvasImage((HtmlCanvas)tmpChild, aContext);
                continue;
            }
            this.writeStartTag(tmpChild, aContext);
            this.output.indent();
            this.writeSubNodes(tmpChild, aContext);
            this.output.unindent();
            this.writeEndTag(tmpChild, aContext);
        }
    }

    private void writeStartTag(DomNode aDomNode, Context aContext) throws IOException {
        if (aDomNode instanceof HtmlHtml) {
            this.output.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">");
            this.output.print("<!-- Browser URL: ").print(this.htmlPage.getUrl().toExternalForm()).println(" -->");
        } else if (aDomNode instanceof HtmlUnknownElement) {
            this.output.print('<');
            this.output.print(((HtmlUnknownElement)aDomNode).getQualifiedName());
            this.writeAttributes(aDomNode);
            this.output.println(">");
        } else if (aDomNode instanceof DomElement) {
            if (aDomNode instanceof HtmlPreformattedText) {
                aContext.insidePre++;
            }
            this.output.print('<');
            this.output.print(this.determineTag(aDomNode));
            this.writeAttributes(aDomNode);
            if (aDomNode instanceof HtmlForm) {
                this.output.print(" onsubmit=\"return false;\"");
            }
            if (EMPTY_TAGS.contains(aDomNode.getClass().getName())) {
                this.output.print('/');
                if (HtmlElementUtil.isBlock(aDomNode) && aContext.insidePre == 0) {
                    this.output.println(">");
                } else {
                    this.output.print(">");
                }
            } else if (SINGLE_LINE_TAGS.contains(aDomNode.getClass().getName()) || aContext.insidePre > 0) {
                this.output.print(">");
            } else {
                this.output.println(">");
            }
            if (aDomNode instanceof HtmlHead) {
                this.output.indent();
                this.output.println("<script src='../../resources/jquery-1.10.2.min.js'></script>");
                this.output.println("<script src='../../resources/jquery.color-2.1.2.min.js'></script>");
                this.output.println("<script src='../../resources/wetator_report.js'></script>");
                this.output.unindent();
            }
        } else if (aDomNode instanceof DomText) {
            String tmpText = ((DomText)aDomNode).getData();
            if (StringUtils.isEmpty((CharSequence)tmpText)) {
                this.output.print(tmpText);
            } else {
                DomNode tmpParentNode = aDomNode.getParentNode();
                if (tmpParentNode instanceof HtmlStyle) {
                    this.output.indent();
                    URL tmpBaseUrl = this.htmlPage.getWebResponse().getWebRequest().getUrl();
                    tmpText = this.responseStore.processCSS(tmpBaseUrl, tmpText, 0);
                    this.output.println(tmpText);
                    this.output.unindent();
                } else if (SINGLE_LINE_TAGS.contains(tmpParentNode.getClass().getName()) || aContext.insidePre > 0) {
                    this.output.print(this.xmlUtil.normalizeBodyValue(tmpText));
                } else {
                    this.output.println(this.xmlUtil.normalizeBodyValue(tmpText));
                }
            }
        } else {
            LOG.warn("Unknown DomNode " + aDomNode);
        }
    }

    private void writeEndTag(DomNode aDomNode, Context aContext) throws IOException {
        if (aDomNode instanceof HtmlHtml) {
            this.output.println("</html>");
        } else if (aDomNode instanceof HtmlUnknownElement) {
            this.output.print("</");
            this.output.print(((DomNamespaceNode)aDomNode).getQualifiedName());
            this.output.println(">");
        } else if (aDomNode instanceof DomElement) {
            if (aDomNode instanceof HtmlBody) {
                this.output.indent();
                this.output.println("<script>");
                this.output.indent();
                this.output.println("highlight();");
                this.output.unindent();
                this.output.println("</script>");
                this.output.unindent();
            }
            if (aDomNode instanceof HtmlPreformattedText) {
                aContext.insidePre--;
            }
            if (!EMPTY_TAGS.contains(aDomNode.getClass().getName())) {
                this.output.print("</");
                this.output.print(this.determineTag(aDomNode));
                if (HtmlElementUtil.isBlock(aDomNode) && aContext.insidePre == 0) {
                    this.output.println(">");
                } else {
                    this.output.print(">");
                }
            }
        }
    }

    private void writeAttributes(DomNode aDomNode) throws IOException {
        if (aDomNode instanceof DomElement) {
            List tmpSortedAttributeNames;
            HtmlLink tmpHtmlLink;
            DomElement tmpDomElement = (DomElement)aDomNode;
            boolean tmpIsCssLink = false;
            if (tmpDomElement instanceof HtmlLink && "stylesheet".equalsIgnoreCase((tmpHtmlLink = (HtmlLink)tmpDomElement).getRelAttribute())) {
                tmpIsCssLink = true;
            }
            boolean tmpIsHtmlImage = tmpDomElement instanceof HtmlImage;
            boolean tmpIsHtmlImageInput = tmpDomElement instanceof HtmlImageInput;
            boolean tmpIsChecked = tmpDomElement instanceof HtmlCheckBoxInput || tmpDomElement instanceof HtmlRadioButtonInput;
            boolean tmpIsHtmlOption = tmpDomElement instanceof HtmlOption;
            URL tmpBaseUrl = this.htmlPage.getWebResponse().getWebRequest().getUrl();
            HashMap tmpAttributes = new HashMap(tmpDomElement.getAttributesMap());
            if (tmpIsHtmlOption && ((HtmlOption)tmpDomElement).isSelected()) {
                this.output.print(" selected=\"selected\"");
            }
            if (tmpIsChecked && ((HtmlInput)tmpDomElement).isChecked()) {
                this.output.print(" checked=\"checked\"");
            }
            if ((tmpSortedAttributeNames = tmpAttributes.keySet().stream().map(k -> k.toLowerCase(Locale.ROOT)).sorted().collect(Collectors.toList())).remove("name")) {
                tmpSortedAttributeNames.add(0, "name");
            }
            if (tmpSortedAttributeNames.remove("id")) {
                tmpSortedAttributeNames.add(0, "id");
            }
            boolean tmpStyleDefined = false;
            for (String tmpAttributeName : tmpSortedAttributeNames) {
                URL tmpUrl;
                String tmpStoredFileName;
                String tmpAttributeValue;
                DomAttr tmpAttribute = (DomAttr)tmpAttributes.get(tmpAttributeName);
                if (IGNORED_ATTRIBUTES.contains(tmpAttributeName) || tmpIsHtmlOption && "selected".equals(tmpAttributeName) || StringUtils.startsWithIgnoreCase((CharSequence)(tmpAttributeValue = tmpAttribute.getNodeValue()), (CharSequence)"javascript:")) continue;
                if ("style".equals(tmpAttributeName)) {
                    tmpStyleDefined = true;
                    if (this.responseStore != null) {
                        tmpAttributeValue = this.responseStore.processCSS(tmpBaseUrl, tmpAttributeValue, 0);
                    }
                    if (aDomNode instanceof HtmlElement && !(aDomNode instanceof HtmlOption)) {
                        HtmlElement tmpElement = (HtmlElement)aDomNode;
                        if (!HtmlElement.DisplayStyle.NONE.value().equals(tmpElement.getDefaultStyleDisplay().value())) {
                            Element tmpElemScript = (Element)aDomNode.getScriptableObject();
                            CSS2Properties tmpStyle = tmpElemScript.getWindow().getComputedStyle((Object)tmpElemScript, null);
                            tmpAttributeValue = tmpAttributeValue + "; display: " + tmpStyle.getDisplay();
                        }
                    }
                }
                if (tmpIsCssLink && "href".equals(tmpAttributeName) && null != (tmpStoredFileName = this.responseStore.storeContentFromUrl(tmpBaseUrl, tmpUrl = tmpDomElement.getHtmlPageOrNull().getFullyQualifiedUrl(tmpAttributeValue), (HtmlLink)tmpDomElement, null, 0, ".css"))) {
                    tmpAttributeValue = tmpStoredFileName;
                }
                if (tmpIsHtmlImage && "src".equals(tmpAttributeName) && null != (tmpStoredFileName = this.responseStore.storeContentFromUrl(tmpBaseUrl, tmpUrl = tmpDomElement.getHtmlPageOrNull().getFullyQualifiedUrl(tmpAttributeValue), null, (HtmlImage)tmpDomElement, 0, null))) {
                    tmpAttributeValue = tmpStoredFileName;
                }
                if ((tmpIsHtmlImageInput || tmpDomElement instanceof HtmlEmbed) && "src".equals(tmpAttributeName) && null != (tmpStoredFileName = this.responseStore.storeContentFromUrl(tmpBaseUrl, tmpUrl = tmpDomElement.getHtmlPageOrNull().getFullyQualifiedUrl(tmpAttributeValue), null, null, 0, null))) {
                    tmpAttributeValue = tmpStoredFileName;
                }
                if (tmpDomElement instanceof BaseFrameElement && "src".equals(tmpAttributeName)) {
                    BaseFrameElement tmpFrame = (BaseFrameElement)aDomNode;
                    FrameWindow tmpWebWindow = tmpFrame.getEnclosedWindow();
                    if (null == tmpWebWindow) {
                        LOG.warn("Frame with enclosed EnclosedWindow == null (" + tmpFrame.toString() + ").");
                    } else {
                        Page tmpPage = tmpWebWindow.getEnclosedPage();
                        if (null == tmpPage) {
                            LOG.warn("Frame with enclosed EnclosedPage == null (" + tmpFrame.toString() + ").");
                        } else {
                            String tmpStoredFileName2 = this.responseStore.storePage(tmpPage);
                            if (null != tmpStoredFileName2) {
                                tmpAttributeValue = "../../" + tmpStoredFileName2;
                            }
                        }
                    }
                }
                if ("background".equals(tmpAttributeName) && (tmpDomElement instanceof HtmlTable || tmpDomElement instanceof HtmlTableHeader || tmpDomElement instanceof HtmlTableRow || tmpDomElement instanceof HtmlTableDataCell) && null != (tmpStoredFileName = this.responseStore.storeContentFromUrl(tmpBaseUrl, tmpUrl = tmpDomElement.getHtmlPageOrNull().getFullyQualifiedUrl(tmpAttributeValue), null, null, 0, null))) {
                    tmpAttributeValue = tmpStoredFileName;
                }
                if (tmpDomElement instanceof HtmlPasswordInput && "value".equals(tmpAttributeName) && StringUtils.isNotEmpty((CharSequence)tmpAttributeValue)) {
                    tmpAttributeValue = StringUtils.repeat((String)"*", (int)tmpAttributeValue.length());
                }
                if (tmpDomElement instanceof HtmlSubmitInput && "value".equals(tmpAttributeName) && "Submit Query".equals(tmpAttributeValue)) continue;
                if ("checked".equals(tmpAttributeName)) {
                    if (tmpIsChecked) continue;
                    if (StringUtils.isEmpty((CharSequence)tmpAttributeValue)) {
                        tmpAttributeValue = "checked";
                    }
                }
                if ("multiple".equals(tmpAttributeName) && StringUtils.isEmpty((CharSequence)tmpAttributeValue)) {
                    tmpAttributeValue = "multiple";
                }
                this.output.print(' ');
                this.output.print(tmpAttributeName);
                this.output.print("=\"");
                this.output.print(this.xmlUtil.normalizeAttributeValue(tmpAttributeValue));
                this.output.print('\"');
            }
            if (!tmpStyleDefined && aDomNode instanceof HtmlElement && !(aDomNode instanceof HtmlOption)) {
                HtmlElement tmpElem = (HtmlElement)aDomNode;
                if (!HtmlElement.DisplayStyle.NONE.value().equals(tmpElem.getDefaultStyleDisplay().value())) {
                    Element tmpElemScript = (Element)aDomNode.getScriptableObject();
                    CSS2Properties tmpStyle = tmpElemScript.getWindow().getComputedStyle((Object)tmpElemScript, null);
                    this.output.print(" style=\"display: ");
                    this.output.print(tmpStyle.getDisplay());
                    this.output.print('\"');
                }
            }
        }
    }

    private String determineTag(DomNode aDomNode) {
        Class<?> tmpNodeClass = aDomNode.getClass();
        String tmpTag = TAG_NAMES.get(tmpNodeClass);
        if (null != tmpTag) {
            return tmpTag;
        }
        while (tmpNodeClass != HtmlElement.class) {
            try {
                Field tmpField = tmpNodeClass.getDeclaredField("TAG_NAME");
                tmpTag = (String)tmpField.get(null);
                TAG_NAMES.put(tmpNodeClass, tmpTag);
                return tmpTag;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                tmpNodeClass = tmpNodeClass.getSuperclass();
            }
        }
        LOG.warn("Unsupported element " + aDomNode);
        return aDomNode.getClass().getName();
    }

    private void writeCanvasImage(HtmlCanvas aCanvas, Context aContext) throws IOException {
        this.output.print("<!-- ");
        this.writeStartTag((DomNode)aCanvas, aContext);
        this.output.indent();
        this.writeSubNodes((DomNode)aCanvas, aContext);
        this.output.unindent();
        this.writeEndTag((DomNode)aCanvas, aContext);
        this.output.println("-->");
        HTMLCanvasElement tmpCanvas = (HTMLCanvasElement)aCanvas.getScriptableObject();
        this.output.print("<img src='");
        this.output.print(tmpCanvas.toDataURL((Object)"png"));
        this.output.print("' height='" + tmpCanvas.getHeight());
        this.output.print("' width='" + tmpCanvas.getWidth());
        String tmpAttrib = aCanvas.getAttribute("style");
        if (DomElement.ATTRIBUTE_NOT_DEFINED != tmpAttrib) {
            this.output.print("' style='" + aCanvas.getAttribute("style"));
        }
        if (DomElement.ATTRIBUTE_NOT_DEFINED != (tmpAttrib = aCanvas.getAttribute("class"))) {
            this.output.print("' class='" + aCanvas.getAttribute("class"));
        }
        this.output.print("'>");
    }

    static {
        TAG_NAMES = new HashMap<Class<? extends Object>, String>(100);
        EMPTY_TAGS = new HashSet<String>();
        EMPTY_TAGS.add(HtmlMeta.class.getName());
        EMPTY_TAGS.add(HtmlLink.class.getName());
        EMPTY_TAGS.add(HtmlFrame.class.getName());
        EMPTY_TAGS.add(HtmlImage.class.getName());
        EMPTY_TAGS.add(HtmlHiddenInput.class.getName());
        EMPTY_TAGS.add(HtmlTextInput.class.getName());
        EMPTY_TAGS.add(HtmlPasswordInput.class.getName());
        EMPTY_TAGS.add(HtmlSubmitInput.class.getName());
        EMPTY_TAGS.add(HtmlButtonInput.class.getName());
        EMPTY_TAGS.add(HtmlImageInput.class.getName());
        EMPTY_TAGS.add(HtmlCheckBoxInput.class.getName());
        EMPTY_TAGS.add(HtmlRadioButtonInput.class.getName());
        EMPTY_TAGS.add(HtmlFileInput.class.getName());
        EMPTY_TAGS.add(HtmlBreak.class.getName());
        EMPTY_TAGS.add(HtmlHorizontalRule.class.getName());
        EMPTY_TAGS.add(HtmlArea.class.getName());
        EMPTY_TAGS.add(HtmlBase.class.getName());
        EMPTY_TAGS.add(HtmlParameter.class.getName());
        EMPTY_TAGS.add(SvgCircle.class.getName());
        EMPTY_TAGS.add(SvgEllipse.class.getName());
        EMPTY_TAGS.add(SvgLine.class.getName());
        EMPTY_TAGS.add(SvgPath.class.getName());
        EMPTY_TAGS.add(SvgPolygon.class.getName());
        EMPTY_TAGS.add(SvgPolyline.class.getName());
        EMPTY_TAGS.add(SvgRect.class.getName());
        SINGLE_LINE_TAGS = new HashSet<String>();
        SINGLE_LINE_TAGS.add(HtmlTitle.class.getName());
        SINGLE_LINE_TAGS.add(HtmlParagraph.class.getName());
        SINGLE_LINE_TAGS.add(HtmlBreak.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading1.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading2.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading3.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading4.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading5.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading6.class.getName());
        SINGLE_LINE_TAGS.add(HtmlOption.class.getName());
        SINGLE_LINE_TAGS.add(HtmlTextArea.class.getName());
        SINGLE_LINE_TAGS.add(HtmlFont.class.getName());
        SINGLE_LINE_TAGS.add(HtmlItalic.class.getName());
        SINGLE_LINE_TAGS.add(HtmlBold.class.getName());
        SINGLE_LINE_TAGS.add(HtmlBig.class.getName());
        SINGLE_LINE_TAGS.add(HtmlCanvas.class.getName());
        SINGLE_LINE_TAGS.add(HtmlEmphasis.class.getName());
        SINGLE_LINE_TAGS.add(HtmlSmall.class.getName());
        SINGLE_LINE_TAGS.add(HtmlStrong.class.getName());
        SINGLE_LINE_TAGS.add(HtmlSubscript.class.getName());
        SINGLE_LINE_TAGS.add(HtmlSuperscript.class.getName());
        SINGLE_LINE_TAGS.add(HtmlInsertedText.class.getName());
        SINGLE_LINE_TAGS.add(HtmlDeletedText.class.getName());
        SINGLE_LINE_TAGS.add(HtmlCode.class.getName());
        SINGLE_LINE_TAGS.add(HtmlKeyboard.class.getName());
        SINGLE_LINE_TAGS.add(HtmlSample.class.getName());
        SINGLE_LINE_TAGS.add(HtmlPreformattedText.class.getName());
        SINGLE_LINE_TAGS.add(HtmlTeletype.class.getName());
        SINGLE_LINE_TAGS.add(HtmlVariable.class.getName());
        SINGLE_LINE_TAGS.add(HtmlAbbreviated.class.getName());
        SINGLE_LINE_TAGS.add(HtmlInlineQuotation.class.getName());
        SINGLE_LINE_TAGS.add(HtmlCitation.class.getName());
        SINGLE_LINE_TAGS.add(HtmlAcronym.class.getName());
        SINGLE_LINE_TAGS.add(HtmlDefinition.class.getName());
        IGNORED_ATTRIBUTES = new HashSet<String>();
        IGNORED_ATTRIBUTES.add("onclick");
        IGNORED_ATTRIBUTES.add("ondblclick");
        IGNORED_ATTRIBUTES.add("onfocus");
        IGNORED_ATTRIBUTES.add("onblur");
        IGNORED_ATTRIBUTES.add("onselect");
        IGNORED_ATTRIBUTES.add("onchange");
        IGNORED_ATTRIBUTES.add("onload");
        IGNORED_ATTRIBUTES.add("onerror");
        IGNORED_ATTRIBUTES.add("onmousemove");
        IGNORED_ATTRIBUTES.add("onmouseover");
        IGNORED_ATTRIBUTES.add("onmouseout");
        IGNORED_ATTRIBUTES.add("onmousedown");
        IGNORED_ATTRIBUTES.add("onmouseup");
        IGNORED_ATTRIBUTES.add("onkeydown");
        IGNORED_ATTRIBUTES.add("onkeyup");
        IGNORED_ATTRIBUTES.add("onkeypress");
    }

    private static final class Context {
        private int insidePre;

        private Context() {
        }
    }
}

