/*
 * Decompiled with CFR 0.152.
 */
package netscape.javascript;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.applet.Applet;
import java.util.Arrays;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import netscape.javascript.JSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSObject {
    private static final Log LOG = LogFactory.getLog(JSObject.class);
    private static Window Window_;
    private final ScriptableObject scriptableObject_;

    public JSObject(ScriptableObject scriptableObject) {
        this.scriptableObject_ = scriptableObject;
    }

    public Object call(String methodName, Object[] args) throws JSException {
        Object jsResult;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("JSObject call '" + methodName + "(" + Arrays.toString(args) + ")'"));
        }
        if ((jsResult = ScriptableObject.callMethod((Scriptable)this.scriptableObject_, (String)methodName, (Object[])args)) instanceof ScriptableObject) {
            return new JSObject((ScriptableObject)jsResult);
        }
        if (jsResult instanceof CharSequence) {
            return jsResult.toString();
        }
        return jsResult;
    }

    public Object eval(String expression) throws JSException {
        Page page;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("JSObject eval '" + expression + "'"));
        }
        if ((page = Window_.getWebWindow().getEnclosedPage()) instanceof HtmlPage) {
            HtmlPage htmlPage = (HtmlPage)page;
            ScriptResult result = htmlPage.executeJavaScript(expression);
            Object jsResult = result.getJavaScriptResult();
            if (jsResult instanceof ScriptableObject) {
                return new JSObject((ScriptableObject)jsResult);
            }
            if (jsResult instanceof CharSequence) {
                return jsResult.toString();
            }
            return jsResult;
        }
        return null;
    }

    public Object getMember(String name) throws JSException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("JSObject getMember '" + name + "'"));
        }
        if (this.scriptableObject_ instanceof Element) {
            return ((Element)this.scriptableObject_).getAttribute(name, null);
        }
        return this.scriptableObject_.get(name, (Scriptable)this.scriptableObject_);
    }

    public void setMember(String name, Object value) throws JSException {
        String stringValue = "";
        if (value != null) {
            stringValue = Context.toString((Object)value);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("JSObject setMember '" + name + "' to '" + stringValue + "'"));
        }
        if (this.scriptableObject_ instanceof Element) {
            ((Element)this.scriptableObject_).setAttribute(name, stringValue);
            return;
        }
        this.scriptableObject_.put(name, (Scriptable)this.scriptableObject_, value);
    }

    public void removeMember(String name) throws JSException {
        LOG.error((Object)"Not yet implemented (netscape.javascript.JSObject.removeMember(String)).");
        throw new RuntimeException("Not yet implemented (netscape.javascript.JSObject.removeMember(String)).");
    }

    public Object getSlot(int index) throws JSException {
        LOG.error((Object)"Not yet implemented (netscape.javascript.JSObject.getSlot(int)).");
        throw new RuntimeException("Not yet implemented (netscape.javascript.JSObject.getSlot(int)).");
    }

    public void setSlot(int index, Object value) throws JSException {
        LOG.error((Object)"Not yet implemented (netscape.javascript.JSObject.setSlot(int, Object)).");
        throw new RuntimeException("Not yet implemented (netscape.javascript.JSObject.setSlot(int, Object)).");
    }

    public static JSObject getWindow(Applet paramApplet) throws JSException {
        return new JSObject(Window_);
    }

    public static void setWindow(Window window) {
        Window_ = window;
    }
}

