/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventListenersContainer
implements Serializable {
    private static final Log LOG = LogFactory.getLog(EventListenersContainer.class);
    private final ConcurrentMap<String, TypeContainer> typeContainers_ = new ConcurrentHashMap<String, TypeContainer>();
    private final EventTarget jsNode_;

    public EventListenersContainer(EventTarget jsNode) {
        this.jsNode_ = jsNode;
    }

    public boolean addEventListener(String type, Scriptable listener, boolean useCapture) {
        if (null == listener) {
            return true;
        }
        boolean[] added = new boolean[]{false};
        this.typeContainers_.compute(type.toLowerCase(Locale.ROOT), (k, container) -> {
            TypeContainer newContainer;
            if (container == null) {
                container = TypeContainer.EMPTY;
            }
            added[0] = (newContainer = container.addListener(listener, useCapture)) != container;
            return newContainer;
        });
        if (!added[0]) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(type + " listener already registered, skipping it (" + listener + ")"));
            }
            return false;
        }
        return true;
    }

    private TypeContainer getTypeContainer(String type) {
        String typeLC = type.toLowerCase(Locale.ROOT);
        return this.typeContainers_.getOrDefault(typeLC, TypeContainer.EMPTY);
    }

    public List<Scriptable> getListeners(String eventType, boolean useCapture) {
        return this.getTypeContainer(eventType).getListeners(useCapture ? 1 : 3);
    }

    void removeEventListener(String eventType, Scriptable listener, boolean useCapture) {
        if (listener == null) {
            return;
        }
        this.typeContainers_.computeIfPresent(eventType.toLowerCase(Locale.ROOT), (k, container) -> container.removeListener(listener, useCapture));
    }

    public void setEventHandler(String eventType, Object value) {
        Function handler = Undefined.isUndefined((Object)value) || !(value instanceof Function) ? null : (Function)value;
        this.typeContainers_.compute(eventType.toLowerCase(Locale.ROOT), (k, container) -> {
            if (container == null) {
                container = TypeContainer.EMPTY;
            }
            return container.setPropertyHandler(handler);
        });
    }

    private void executeEventListeners(int eventPhase, Event event, Object[] args) {
        DomNode node = this.jsNode_.getDomNodeOrNull();
        if (node != null && !node.handles(event)) {
            return;
        }
        TypeContainer container = this.getTypeContainer(event.getType());
        List<Scriptable> listeners = container.getListeners(eventPhase);
        if (!listeners.isEmpty()) {
            Scriptable parentScope;
            event.setCurrentTarget((Scriptable)this.jsNode_);
            HtmlPage page = this.jsNode_ instanceof Window ? (HtmlPage)this.jsNode_.getDomNodeOrDie() : ((parentScope = this.jsNode_.getParentScope()) instanceof Window ? (HtmlPage)((Window)parentScope).getDomNodeOrDie() : (parentScope instanceof HTMLDocument ? ((HTMLDocument)parentScope).getPage() : ((HTMLElement)parentScope).getDomNodeOrDie().getHtmlPageOrNull()));
            for (Scriptable listener : listeners) {
                Object handleEvent;
                boolean isPropertyHandler = false;
                if (listener == TypeContainer.EVENT_HANDLER_PLACEHOLDER) {
                    listener = container.handler_;
                    isPropertyHandler = true;
                }
                Function function = null;
                EventTarget thisObject = null;
                if (listener instanceof Function) {
                    function = (Function)listener;
                    thisObject = this.jsNode_;
                } else if (listener instanceof NativeObject && (handleEvent = ScriptableObject.getProperty((Scriptable)listener, (String)"handleEvent")) instanceof Function) {
                    function = (Function)handleEvent;
                    thisObject = listener;
                }
                if (function != null) {
                    ScriptResult result = page.executeJavaScriptFunction((Object)function, thisObject, args, node);
                    if (isPropertyHandler && !ScriptResult.isUndefined(result)) {
                        event.handlePropertyHandlerReturnValue(result.getJavaScriptResult());
                    }
                }
                if (!event.isImmediatePropagationStopped()) continue;
                return;
            }
        }
    }

    public void executeBubblingListeners(Event event, Object[] args) {
        this.executeEventListeners(3, event, args);
    }

    public void executeCapturingListeners(Event event, Object[] args) {
        this.executeEventListeners(1, event, args);
    }

    public void executeAtTargetListeners(Event event, Object[] args) {
        this.executeEventListeners(2, event, args);
    }

    public Function getEventHandler(String eventType) {
        return this.getTypeContainer(eventType).handler_;
    }

    boolean hasEventListeners(String eventType) {
        return !this.getTypeContainer(eventType).atTargetListeners_.isEmpty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[node=" + this.jsNode_ + " handlers=" + this.typeContainers_.keySet() + "]";
    }

    private static class TypeContainer
    implements Serializable {
        public static final TypeContainer EMPTY = new TypeContainer();
        private static final Scriptable EVENT_HANDLER_PLACEHOLDER = null;
        private final List<Scriptable> capturingListeners_;
        private final List<Scriptable> bubblingListeners_;
        private final List<Scriptable> atTargetListeners_;
        private final Function handler_;

        TypeContainer() {
            this.capturingListeners_ = Collections.emptyList();
            this.bubblingListeners_ = Collections.emptyList();
            this.atTargetListeners_ = Collections.emptyList();
            this.handler_ = null;
        }

        private TypeContainer(List<Scriptable> capturingListeners, List<Scriptable> bubblingListeners, List<Scriptable> atTargetListeners, Function handler) {
            this.capturingListeners_ = capturingListeners;
            this.bubblingListeners_ = bubblingListeners;
            this.atTargetListeners_ = atTargetListeners;
            this.handler_ = handler;
        }

        List<Scriptable> getListeners(int eventPhase) {
            switch (eventPhase) {
                case 1: {
                    return this.capturingListeners_;
                }
                case 2: {
                    return this.atTargetListeners_;
                }
                case 3: {
                    return this.bubblingListeners_;
                }
            }
            throw new UnsupportedOperationException("eventPhase: " + eventPhase);
        }

        public TypeContainer setPropertyHandler(Function propertyHandler) {
            if (propertyHandler != null) {
                if (this.handler_ != null) {
                    if (propertyHandler == this.handler_) {
                        return this;
                    }
                    return this.withPropertyHandler(propertyHandler);
                }
                return this.withPropertyHandler(propertyHandler).addListener(EVENT_HANDLER_PLACEHOLDER, false);
            }
            if (this.handler_ == null) {
                return this;
            }
            return this.removeListener(EVENT_HANDLER_PLACEHOLDER, false).withPropertyHandler(null);
        }

        private TypeContainer withPropertyHandler(Function propertyHandler) {
            return new TypeContainer(this.capturingListeners_, this.bubblingListeners_, this.atTargetListeners_, propertyHandler);
        }

        public TypeContainer addListener(Scriptable listener, boolean useCapture) {
            List<Scriptable> listeners;
            List<Scriptable> capturingListeners = this.capturingListeners_;
            List<Scriptable> bubblingListeners = this.bubblingListeners_;
            List<Scriptable> list = listeners = useCapture ? capturingListeners : bubblingListeners;
            if (listeners.contains(listener)) {
                return this;
            }
            List<Object> newListeners = new ArrayList<Scriptable>(listeners.size() + 1);
            newListeners.addAll(listeners);
            newListeners.add(listener);
            newListeners = Collections.unmodifiableList(newListeners);
            if (useCapture) {
                capturingListeners = newListeners;
            } else {
                bubblingListeners = newListeners;
            }
            ArrayList<Scriptable> atTargetListeners = new ArrayList<Scriptable>(this.atTargetListeners_.size() + 1);
            atTargetListeners.addAll(this.atTargetListeners_);
            atTargetListeners.add(listener);
            atTargetListeners = Collections.unmodifiableList(atTargetListeners);
            return new TypeContainer(capturingListeners, bubblingListeners, atTargetListeners, this.handler_);
        }

        public TypeContainer removeListener(Scriptable listener, boolean useCapture) {
            List<Scriptable> capturingListeners = this.capturingListeners_;
            List<Scriptable> bubblingListeners = this.bubblingListeners_;
            List<Scriptable> listeners = useCapture ? capturingListeners : bubblingListeners;
            int idx = listeners.indexOf(listener);
            if (idx < 0) {
                return this;
            }
            List<Scriptable> newListeners = new ArrayList<Scriptable>(listeners);
            newListeners.remove(idx);
            newListeners = Collections.unmodifiableList(newListeners);
            if (useCapture) {
                capturingListeners = newListeners;
            } else {
                bubblingListeners = newListeners;
            }
            List<Scriptable> atTargetListeners = new ArrayList<Scriptable>(this.atTargetListeners_);
            atTargetListeners.remove(listener);
            atTargetListeners = Collections.unmodifiableList(atTargetListeners);
            return new TypeContainer(capturingListeners, bubblingListeners, atTargetListeners, this.handler_);
        }

        protected TypeContainer clone() {
            return new TypeContainer(this.capturingListeners_, this.bubblingListeners_, this.atTargetListeners_, this.handler_);
        }
    }
}

