/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptFunctionJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.EvaluatorException;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.codec.binary.Base64;

public final class WindowOrWorkerGlobalScopeMixin {
    private static final int MIN_TIMER_DELAY = 1;

    private WindowOrWorkerGlobalScopeMixin() {
    }

    public static String atob(String encodedData) {
        int l = encodedData.length();
        for (int i = 0; i < l; ++i) {
            if (encodedData.charAt(i) <= '\u00ff') continue;
            throw new EvaluatorException("Function atob supports only latin1 characters");
        }
        byte[] bytes = encodedData.getBytes(StandardCharsets.ISO_8859_1);
        return new String(Base64.decodeBase64((byte[])bytes), StandardCharsets.ISO_8859_1);
    }

    public static String btoa(String stringToEncode) {
        int l = stringToEncode.length();
        for (int i = 0; i < l; ++i) {
            if (stringToEncode.charAt(i) <= '\u00ff') continue;
            throw new EvaluatorException("Function btoa supports only latin1 characters");
        }
        byte[] bytes = stringToEncode.getBytes(StandardCharsets.ISO_8859_1);
        return new String(Base64.encodeBase64((byte[])bytes), StandardCharsets.UTF_8);
    }

    public static Object setTimeout(Context context, Scriptable thisObj, Object[] args, Function function) {
        if (args.length < 1) {
            throw ScriptRuntime.typeError((String)"Function not provided");
        }
        int timeout = ScriptRuntime.toInt32((Object)(args.length > 1 ? args[1] : Undefined.instance));
        Object[] params = args.length > 2 ? Arrays.copyOfRange(args, 2, args.length) : ScriptRuntime.emptyArgs;
        return WindowOrWorkerGlobalScopeMixin.setTimeoutIntervalImpl((Window)thisObj, args[0], timeout, true, params);
    }

    public static Object setInterval(Context context, Scriptable thisObj, Object[] args, Function function) {
        if (args.length < 1) {
            throw ScriptRuntime.typeError((String)"Function not provided");
        }
        int timeout = ScriptRuntime.toInt32((Object)(args.length > 1 ? args[1] : Undefined.instance));
        Object[] params = args.length > 2 ? Arrays.copyOfRange(args, 2, args.length) : ScriptRuntime.emptyArgs;
        return WindowOrWorkerGlobalScopeMixin.setTimeoutIntervalImpl((Window)thisObj, args[0], timeout, false, params);
    }

    private static int setTimeoutIntervalImpl(Window window, Object code, int timeout, boolean isTimeout, Object[] params) {
        if (timeout < 1) {
            timeout = 1;
        }
        WebWindow webWindow = window.getWebWindow();
        Page page = (Page)((Object)window.getDomNodeOrNull());
        Integer period = null;
        if (!isTimeout) {
            period = timeout;
        }
        if (code instanceof String) {
            String s = (String)code;
            String description = "window.set" + (isTimeout ? "Timeout" : "Interval") + "(" + s + ", " + timeout + ")";
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, period, description, webWindow, s);
            return webWindow.getJobManager().addJob(job, page);
        }
        if (code instanceof Function) {
            Function f = (Function)code;
            String functionName = f instanceof FunctionObject ? ((FunctionObject)f).getFunctionName() : String.valueOf(f);
            String description = "window.set" + (isTimeout ? "Timeout" : "Interval") + "(" + functionName + ", " + timeout + ")";
            JavaScriptFunctionJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(timeout, period, description, webWindow, f, params);
            return webWindow.getJobManager().addJob(job, page);
        }
        throw Context.reportRuntimeError((String)"Unknown type for function.");
    }
}

