/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlSelectableTextInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class HtmlEmailInput
extends HtmlSelectableTextInput
implements LabelableElement {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+\\/=?^_`\\{|\\}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$");

    HtmlEmailInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValueAttribute(String newValue) {
        if (StringUtils.isBlank((CharSequence)newValue) && this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_EMAIL_TRIMMED)) {
            newValue = "";
        }
        super.setValueAttribute(newValue);
    }

    @Override
    public boolean isValid() {
        boolean isValid = super.isValid();
        if (!isValid) {
            return false;
        }
        String val = this.getValueAttribute();
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return DEFAULT_PATTERN.matcher(val).matches();
        }
        return true;
    }

    @Override
    protected boolean isPatternSupported() {
        return true;
    }

    @Override
    protected boolean isBlankPatternValidated() {
        return false;
    }
}

