/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.ValidatableElement;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlButton
extends HtmlElement
implements DisabledElement,
SubmittableElement,
LabelableElement,
FormFieldWithNameHistory,
ValidatableElement {
    private static final Log LOG = LogFactory.getLog(HtmlButton.class);
    public static final String TAG_NAME = "button";
    private static final String TYPE_SUBMIT = "submit";
    private static final String TYPE_RESET = "reset";
    private static final String TYPE_BUTTON = "button";
    private final String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();
    private String customValidity_;

    HtmlButton(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.originalName_ = this.getNameAttribute();
    }

    public void setValueAttribute(String newValue) {
        this.setAttribute("value", newValue);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        if (this.hasFeature(BrowserVersionFeatures.HTMLBUTTON_SUBMIT_IGNORES_DISABLED_STATE) || !this.isDisabled()) {
            HtmlForm form = null;
            String formId = this.getAttributeDirect("form");
            if (DomElement.ATTRIBUTE_NOT_DEFINED == formId || !this.hasFeature(BrowserVersionFeatures.FORM_FORM_ATTRIBUTE_SUPPORTED)) {
                form = this.getEnclosingForm();
            } else {
                DomElement elem = this.getHtmlPageOrNull().getElementById(formId);
                if (elem instanceof HtmlForm) {
                    form = (HtmlForm)elem;
                }
            }
            if (form != null) {
                String type = this.getType();
                if ("button".equals(type)) {
                    return false;
                }
                if (TYPE_RESET.equals(type)) {
                    form.reset();
                    return false;
                }
                form.submit(this);
                return false;
            }
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    @Override
    public void reset() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"reset() not implemented for this element");
        }
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setDefaultValue() not implemented for this element");
        }
    }

    @Override
    public String getDefaultValue() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getDefaultValue() not implemented for this element");
        }
        return "";
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    @Override
    public boolean handles(Event event) {
        if (event instanceof MouseEvent && this.hasFeature(BrowserVersionFeatures.EVENT_MOUSE_ON_DISABLED)) {
            return true;
        }
        return super.handles(event);
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getValueAttribute() {
        return this.getAttributeDirect("value");
    }

    @Override
    public String getAttribute(String attributeName) {
        String type = super.getAttribute(attributeName);
        if (type == DomElement.ATTRIBUTE_NOT_DEFINED && "type".equalsIgnoreCase(attributeName)) {
            type = TYPE_SUBMIT;
        }
        return type;
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public String getType() {
        String type = this.getTypeAttribute();
        if (null != type) {
            type = type.toLowerCase(Locale.ROOT);
        }
        if (TYPE_RESET.equals(type)) {
            return TYPE_RESET;
        }
        if ("button".equals(type)) {
            return "button";
        }
        return TYPE_SUBMIT;
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeDirect("disabled");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeDirect("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        if ("name".equals(qualifiedName)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE_BLOCK;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    public boolean isValid() {
        if (TYPE_RESET.equals(this.getType())) {
            return true;
        }
        return super.isValid() && !this.isCustomErrorValidityState();
    }

    @Override
    public boolean willValidate() {
        if (TYPE_RESET.equals(this.getType()) || "button".equals(this.getType())) {
            return false;
        }
        return !this.isDisabled() && (this.hasFeature(BrowserVersionFeatures.HTMLBUTTON_WILL_VALIDATE_IGNORES_READONLY) || !this.isReadOnly());
    }

    @Override
    public void setCustomValidity(String message) {
        this.customValidity_ = message;
    }

    @Override
    public boolean hasBadInputValidityState() {
        return false;
    }

    @Override
    public boolean isCustomErrorValidityState() {
        return !StringUtils.isEmpty((CharSequence)this.customValidity_);
    }

    @Override
    public boolean hasPatternMismatchValidityState() {
        return false;
    }

    @Override
    public boolean isStepMismatchValidityState() {
        return false;
    }

    @Override
    public boolean isTooLongValidityState() {
        return false;
    }

    @Override
    public boolean isTooShortValidityState() {
        return false;
    }

    @Override
    public boolean hasTypeMismatchValidityState() {
        return false;
    }

    @Override
    public boolean hasRangeOverflowValidityState() {
        return false;
    }

    @Override
    public boolean hasRangeUnderflowValidityState() {
        return false;
    }

    @Override
    public boolean isValidValidityState() {
        return !this.isCustomErrorValidityState();
    }

    @Override
    public boolean isValueMissingValidityState() {
        return false;
    }

    public final boolean isFormNoValidate() {
        return this.hasAttribute("formnovalidate");
    }

    public final void setFormNoValidate(boolean noValidate) {
        if (noValidate) {
            this.setAttribute("formnovalidate", "formnovalidate");
        } else {
            this.removeAttribute("formnovalidate");
        }
    }
}

