/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.wetator.core.Variable;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public final class SecretString {
    public static final String SECRET_PRINT = "****";
    private static final String VAR_START_SEQ = "${";
    private static final String VAR_END_SEQ = "}";
    private String value = "";
    private List<FindSpot> secrets = new LinkedList<FindSpot>();

    public SecretString() {
    }

    public SecretString(String aPublicText) {
        this();
        this.append(aPublicText);
    }

    public SecretString append(String aPublicText) {
        if (StringUtils.isNotEmpty((CharSequence)aPublicText)) {
            this.value = this.value + aPublicText;
        }
        return this;
    }

    public SecretString appendSecret(String aSecretText) {
        if (null != aSecretText) {
            FindSpot tmpSecretSpot = new FindSpot(this.value.length(), -1);
            this.value = this.value + aSecretText;
            tmpSecretSpot.setEndPos(this.value.length());
            this.secrets.add(tmpSecretSpot);
        }
        return this;
    }

    public SecretString prefixWith(String aPublicText) {
        if (StringUtils.isNotEmpty((CharSequence)aPublicText)) {
            this.value = aPublicText + this.value;
            this.moveSecrets(aPublicText.length(), 0);
        }
        return this;
    }

    public SecretString trim() {
        int tmpEnd;
        int tmpStart;
        int tmpLength = this.value.length();
        for (tmpStart = 0; tmpStart < tmpLength && Character.isWhitespace(this.value.charAt(tmpStart)); ++tmpStart) {
        }
        for (tmpEnd = tmpLength - 1; tmpEnd > tmpStart && Character.isWhitespace(this.value.charAt(tmpEnd)); --tmpEnd) {
        }
        if (tmpEnd < tmpStart) {
            this.value = "";
            this.secrets = new LinkedList<FindSpot>();
            return this;
        }
        this.value = this.value.substring(tmpStart, tmpEnd + 1);
        this.moveSecrets(tmpStart * -1, 0);
        return this;
    }

    public SecretString substring(int aBeginIndex) {
        return this.substring(aBeginIndex, this.length());
    }

    public SecretString substring(int aBeginIndex, int anEndIndex) {
        SecretString tmpResult = new SecretString(this.value.substring(aBeginIndex, anEndIndex));
        this.secrets.forEach(f -> tmpResult.secrets.add(new FindSpot((FindSpot)f)));
        tmpResult.moveSecrets(aBeginIndex * -1, 0);
        return tmpResult;
    }

    public boolean startsWith(String aPrefix) {
        return this.value.startsWith(aPrefix);
    }

    public boolean startsWith(String aPrefix, int anOffset) {
        return this.value.startsWith(aPrefix, anOffset);
    }

    public boolean endsWith(String aSuffix) {
        return this.value.endsWith(aSuffix);
    }

    public boolean contains(CharSequence aPart) {
        return this.value.contains(aPart);
    }

    public List<SecretString> split(String aDelimiter, int anEscapeChar) {
        int tmpDelimiterSize = aDelimiter.length();
        if (tmpDelimiterSize == 0) {
            throw new IllegalArgumentException("Delimiter must not be an empty string.");
        }
        if (tmpDelimiterSize == 1 && aDelimiter.charAt(0) == anEscapeChar) {
            throw new IllegalArgumentException("Delimiter must be different from escape char.");
        }
        LinkedList<SecretString> tmpResult = new LinkedList<SecretString>();
        int tmpSize = this.length();
        if (tmpSize < tmpDelimiterSize) {
            return tmpResult;
        }
        int tmpStartPos = 0;
        int tmpSplitPos = this.value.indexOf(aDelimiter);
        LinkedList<Integer> tmpEscPos = new LinkedList<Integer>();
        while (tmpSplitPos > -1) {
            char tmpEscape;
            if (tmpSplitPos > 0 && (tmpEscape = this.value.charAt(tmpSplitPos - 1)) == anEscapeChar) {
                tmpEscPos.add(0, tmpSplitPos - tmpStartPos - 1);
                tmpSplitPos = this.value.indexOf(aDelimiter, tmpSplitPos + tmpDelimiterSize);
                continue;
            }
            SecretString tmpPart = this.substring(tmpStartPos, tmpSplitPos);
            tmpPart.removeEsc(tmpEscPos);
            tmpEscPos.clear();
            tmpResult.add(tmpPart);
            tmpStartPos = tmpSplitPos + tmpDelimiterSize;
            tmpSplitPos = this.value.indexOf(aDelimiter, tmpSplitPos + tmpDelimiterSize);
        }
        SecretString tmpPart = this.substring(tmpStartPos, tmpSize);
        tmpPart.removeEsc(tmpEscPos);
        tmpResult.add(tmpPart);
        return tmpResult;
    }

    private void removeEsc(List<Integer> anEscPosList) {
        StringBuilder tmpBuilder = new StringBuilder(this.value);
        for (Integer tmpEscPos : anEscPosList) {
            int tmpPos = tmpEscPos;
            tmpBuilder.replace(tmpPos, tmpPos + 1, "");
            this.moveSecrets(-1, tmpPos);
        }
        this.value = tmpBuilder.toString();
    }

    private void moveSecrets(int aDistance, int aStartPos) {
        int tmpLength = this.value.length();
        Iterator<FindSpot> tmpSecrets = this.secrets.iterator();
        while (tmpSecrets.hasNext()) {
            int tmpEnd;
            FindSpot tmpSpot = tmpSecrets.next();
            int tmpStart = tmpSpot.getStartPos();
            if (aStartPos <= tmpStart) {
                tmpSpot.setStartPos(Math.max(0, tmpStart + aDistance));
            }
            if (aStartPos <= (tmpEnd = tmpSpot.getEndPos())) {
                tmpSpot.setEndPos(Math.min(tmpLength, tmpEnd + aDistance));
            }
            if (0 <= tmpSpot.getEndPos() && tmpSpot.getEndPos() > tmpSpot.getStartPos()) continue;
            tmpSecrets.remove();
        }
    }

    public int length() {
        return this.value.length();
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.value);
    }

    public String toLowerCase(Locale aLocale) {
        return this.value.toLowerCase(aLocale);
    }

    public SecretString replaceVariables(List<Variable> aVariables) {
        int tmpLoops;
        if (null == aVariables || aVariables.isEmpty()) {
            return this;
        }
        int tmpReplace = this.replace(aVariables, this.value.length());
        for (tmpLoops = 0; tmpReplace > -1 && tmpLoops < 4444; ++tmpLoops) {
            tmpReplace = this.replace(aVariables, tmpReplace);
        }
        if (tmpLoops >= 4444) {
            throw new IllegalArgumentException("Recursion during variable replacement (" + this.toString() + ").");
        }
        Collections.sort(this.secrets, (aFindSpot1, aFindSpot2) -> aFindSpot1.getStartPos() - aFindSpot2.getStartPos());
        return this;
    }

    private int replace(List<Variable> aVariables, int aFrom) {
        int tmpVarStartPos = this.value.lastIndexOf(VAR_START_SEQ, aFrom);
        if (tmpVarStartPos < 0) {
            return -1;
        }
        int tmpVarEndPos = this.value.indexOf(VAR_END_SEQ, tmpVarStartPos);
        if (tmpVarEndPos < 0) {
            return tmpVarStartPos - 1;
        }
        String tmpVarName = this.value.substring(tmpVarStartPos + VAR_START_SEQ.length(), tmpVarEndPos);
        ++tmpVarEndPos;
        for (Variable tmpVariable : aVariables) {
            if (!tmpVarName.equals(tmpVariable.getName())) continue;
            SecretString tmpVarSecret = tmpVariable.getValue();
            String tmpVarSecretValue = tmpVarSecret.getValue();
            this.value = this.value.substring(0, tmpVarStartPos) + tmpVarSecretValue + this.value.substring(tmpVarEndPos);
            int tmpOffset = tmpVarSecretValue.length() - (tmpVarEndPos - tmpVarStartPos);
            boolean tmpEnclosed = false;
            Iterator<FindSpot> tmpSecretsIterator = this.secrets.iterator();
            while (tmpSecretsIterator.hasNext()) {
                FindSpot tmpSpot = tmpSecretsIterator.next();
                if (tmpSpot.getStartPos() <= tmpVarStartPos && tmpVarEndPos <= tmpSpot.getEndPos()) {
                    tmpSpot.setEndPos(tmpSpot.getEndPos() + tmpOffset);
                    tmpEnclosed = true;
                    continue;
                }
                if (tmpSpot.getStartPos() > tmpVarStartPos && tmpVarEndPos > tmpSpot.getEndPos()) {
                    tmpSecretsIterator.remove();
                    continue;
                }
                if (tmpVarStartPos < tmpSpot.getStartPos()) {
                    tmpSpot.setStartPos(tmpSpot.getStartPos() + tmpOffset);
                }
                if (tmpVarEndPos >= tmpSpot.getEndPos()) continue;
                tmpSpot.setEndPos(tmpSpot.getEndPos() + tmpOffset);
            }
            if (!tmpEnclosed) {
                for (FindSpot tmpSpot : tmpVarSecret.secrets) {
                    FindSpot tmpNewSpot = new FindSpot();
                    tmpNewSpot.setStartPos(tmpSpot.getStartPos() + tmpVarStartPos);
                    tmpNewSpot.setEndPos(tmpSpot.getEndPos() + tmpVarStartPos);
                    this.secrets.add(tmpNewSpot);
                }
            }
            if ((VAR_START_SEQ + tmpVarName + VAR_END_SEQ).equals(tmpVarSecretValue)) continue;
            return aFrom;
        }
        return tmpVarStartPos - 1;
    }

    public SearchPattern getSearchPattern() {
        return SearchPattern.compile(this.getValue());
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder tmpResult = new StringBuilder();
        int tmpStart = 0;
        for (FindSpot tmpSpot : this.secrets) {
            tmpResult.append(this.value.substring(tmpStart, tmpSpot.getStartPos()));
            tmpResult.append(SECRET_PRINT);
            tmpStart = tmpSpot.getEndPos();
        }
        if (tmpStart == 0) {
            tmpResult.append(this.value);
        } else {
            tmpResult.append(this.value.substring(tmpStart, this.value.length()));
        }
        return tmpResult.toString();
    }
}

