/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public final class Output {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private Writer writer;
    private StringBuffer currentIndent;
    private boolean afterNewLine;
    private final String indent;

    public Output(Writer aWriter, String anIndent) {
        this.writer = new BufferedWriter(aWriter);
        this.indent = anIndent;
        this.currentIndent = new StringBuffer();
    }

    public Output print(char aChar) throws IOException {
        this.writeIndentIfNeeded();
        this.writer.write(aChar);
        return this;
    }

    public Output print(String aString) throws IOException {
        if (null != aString) {
            this.writeIndentIfNeeded();
            this.writer.write(aString);
        }
        return this;
    }

    public Output println(String aString) throws IOException {
        if (this.afterNewLine && StringUtils.isBlank((CharSequence)aString)) {
            this.writer.write(NEW_LINE);
            return this;
        }
        this.writeIndentIfNeeded();
        this.writer.write(aString);
        this.writer.write(NEW_LINE);
        this.afterNewLine = true;
        return this;
    }

    public Output println() throws IOException {
        this.writer.write(NEW_LINE);
        this.afterNewLine = true;
        return this;
    }

    public Output printStringWithNewLine(String aString) throws IOException {
        this.writeIndentIfNeeded();
        this.writer.write(aString);
        this.afterNewLine = true;
        return this;
    }

    public Output flush() throws IOException {
        this.writer.flush();
        return this;
    }

    public Output close() throws IOException {
        this.writer.flush();
        this.writer.close();
        return this;
    }

    public Output indent() {
        this.currentIndent.append(this.indent);
        return this;
    }

    public Output unindent() {
        this.currentIndent.setLength(Math.max(0, this.currentIndent.length() - this.indent.length()));
        return this;
    }

    private void writeIndentIfNeeded() throws IOException {
        if (this.afterNewLine) {
            this.writer.write(this.currentIndent.toString());
            this.afterNewLine = false;
        }
    }
}

