/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.util;

import org.wetator.exception.ImplementationException;

public class FindSpot {
    public static final FindSpot NOT_FOUND = new FixedFindSpot(-1, -1);
    private int startPos;
    private int endPos;

    public FindSpot() {
        this(-1, -1);
    }

    public FindSpot(int aStartPos, int anEndPos) {
        this.startPos = aStartPos;
        this.endPos = anEndPos;
    }

    public FindSpot(FindSpot aFindSpot) {
        this.startPos = aFindSpot.getStartPos();
        this.endPos = aFindSpot.getEndPos();
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setStartPos(int aStartPos) {
        this.startPos = aStartPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public void setEndPos(int aEndPos) {
        this.endPos = aEndPos;
    }

    public int hashCode() {
        int tmpPrime = 31;
        int tmpHash = 1;
        tmpHash = 31 * tmpHash + this.endPos;
        tmpHash = 31 * tmpHash + this.startPos;
        return tmpHash;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        if (this.getClass() != anObject.getClass()) {
            return false;
        }
        FindSpot tmpOtherFindSpot = (FindSpot)anObject;
        if (this.endPos != tmpOtherFindSpot.endPos) {
            return false;
        }
        return this.startPos == tmpOtherFindSpot.startPos;
    }

    public String toString() {
        return "FindSpot(" + this.startPos + ", " + this.endPos + ")";
    }

    public static final class FixedFindSpot
    extends FindSpot {
        public FixedFindSpot(int aStartPos, int anEndPos) {
            super(aStartPos, anEndPos);
        }

        @Override
        public void setStartPos(int aStartPos) {
            throw new ImplementationException("FixedFindSpot does not support changing its values.");
        }

        @Override
        public void setEndPos(int aEndPos) {
            throw new ImplementationException("FixedFindSpot does not support changing its values.");
        }

        @Override
        public String toString() {
            if (this == NOT_FOUND) {
                return "FixedFindSpot(NOT_FOUND)";
            }
            return "FixedFindSpot(" + this.getStartPos() + ", " + this.getEndPos() + ")";
        }
    }
}

