/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.extractor.POITextExtractor;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.wetator.backend.IBrowser;
import org.wetator.backend.htmlunit.util.ContentTypeUtil;
import org.wetator.util.NormalizedString;
import org.wetator.util.StringUtil;

public final class ContentUtil {
    private static final Logger LOG = LogManager.getLogger(ContentUtil.class);
    private static final String MORE = " ...";

    public static String getTxtContentAsString(String aContent, int aMaxLength) {
        NormalizedString tmpResult = new NormalizedString(aContent);
        if (tmpResult.length() > aMaxLength) {
            return tmpResult.substring(0, aMaxLength) + MORE;
        }
        return tmpResult.toString();
    }

    public static String getTxtContentAsString(InputStream anInputStream, Charset aCharset, int aMaxLength) throws IOException {
        int tmpChars;
        boolean tmpContinue;
        if (anInputStream == null) {
            return "";
        }
        NormalizedString tmpResult = new NormalizedString();
        InputStreamReader tmpReader = new InputStreamReader(anInputStream, aCharset);
        char[] tmpCharBuffer = new char[1024];
        do {
            tmpChars = tmpReader.read(tmpCharBuffer);
            tmpResult.append(tmpCharBuffer, tmpChars);
        } while (tmpContinue = tmpChars > 0 && tmpResult.length() <= aMaxLength);
        if (tmpResult.length() > aMaxLength) {
            return tmpResult.substring(0, aMaxLength) + MORE;
        }
        return tmpResult.toString();
    }

    public static String getPdfContentAsString(InputStream anInputStream, int aMaxLength) throws IOException {
        if (anInputStream == null) {
            return "";
        }
        try (PDDocument tmpDocument = PDDocument.load((InputStream)anInputStream);){
            AccessPermission tmpPermissions = tmpDocument.getCurrentAccessPermission();
            if (!tmpPermissions.canExtractContent()) {
                throw new IOException("Content extraction forbidden for the given PDF document.");
            }
            PDFTextStripper tmpStripper = new PDFTextStripper();
            String tmpContentAsText = tmpStripper.getText(tmpDocument);
            NormalizedString tmpResult = new NormalizedString(tmpContentAsText);
            if (tmpResult.length() > aMaxLength) {
                String string = tmpResult.substring(0, aMaxLength) + MORE;
                return string;
            }
            String string = tmpResult.toString();
            return string;
        }
    }

    public static String getPdfTitleAsString(InputStream anInputStream) throws IOException {
        if (anInputStream == null) {
            return "";
        }
        try (PDDocument tmpDocument = PDDocument.load((InputStream)anInputStream);){
            PDDocumentInformation tmpInfo = tmpDocument.getDocumentInformation();
            if (null != tmpInfo) {
                NormalizedString tmpResult = new NormalizedString(tmpInfo.getTitle());
                String string = tmpResult.toString();
                return string;
            }
            String string = "";
            return string;
        }
    }

    public static String getRtfContentAsString(InputStream anInputStream, int aMaxLength) throws IOException, BadLocationException {
        int tmpLength;
        if (anInputStream == null) {
            return "";
        }
        RTFEditorKit tmpRtfEditorKit = new RTFEditorKit();
        Document tmpDocument = tmpRtfEditorKit.createDefaultDocument();
        tmpRtfEditorKit.read(anInputStream, tmpDocument, 0);
        NormalizedString tmpResult = new NormalizedString(tmpDocument.getText(0, tmpLength));
        for (tmpLength = Math.min(tmpDocument.getLength(), aMaxLength); tmpResult.length() <= aMaxLength && tmpLength < tmpDocument.getLength(); ++tmpLength) {
            tmpResult.append(tmpDocument.getText(tmpLength, 1));
        }
        if (tmpResult.length() > aMaxLength) {
            tmpResult = new NormalizedString(tmpResult.substring(0, tmpResult.length() - 1));
        }
        if (tmpDocument.getLength() > tmpLength) {
            tmpResult.append(MORE);
        }
        return tmpResult.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getWordContentAsString(InputStream anInputStream, int aMaxLength) throws IOException, InvalidFormatException {
        if (anInputStream == null) {
            return "";
        }
        try (POITextExtractor tmpExtractor = ExtractorFactory.createExtractor((InputStream)anInputStream);){
            if (!(tmpExtractor instanceof XWPFWordExtractor) && !(tmpExtractor instanceof WordExtractor)) {
                throw new InvalidFormatException("Your InputStream was not a Word document");
            }
            NormalizedString tmpResult = new NormalizedString(tmpExtractor.getText());
            if (tmpResult.length() <= aMaxLength) {
                String string = tmpResult.toString();
                return string;
            }
            tmpResult = new NormalizedString(tmpResult.substring(0, aMaxLength));
            tmpResult.append(MORE);
            String string = tmpResult.toString();
            return string;
        }
        catch (IllegalArgumentException | OpenXML4JException e) {
            if (e.getCause() instanceof InvalidFormatException) {
                throw (InvalidFormatException)e.getCause();
            }
            InvalidFormatException tmpEx = new InvalidFormatException(e.getMessage());
            tmpEx.initCause(e);
            throw tmpEx;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getExcelContentAsString(InputStream anInputStream, Locale aLocale, int aMaxLength) throws IOException, InvalidFormatException {
        if (anInputStream == null) {
            return "";
        }
        NormalizedString tmpResult = new NormalizedString();
        try (Workbook tmpWorkbook = WorkbookFactory.create((InputStream)anInputStream);){
            FormulaEvaluator tmpFormulaEvaluator = tmpWorkbook.getCreationHelper().createFormulaEvaluator();
            Locale tmpLocale = aLocale;
            if (null == tmpLocale) {
                tmpLocale = Locale.getDefault();
            }
            int i = 0;
            while (i < tmpWorkbook.getNumberOfSheets()) {
                Sheet tmpSheet = tmpWorkbook.getSheetAt(i);
                tmpResult.append("[");
                tmpResult.append(tmpSheet.getSheetName());
                tmpResult.append("] ");
                for (int tmpRowNum = 0; tmpRowNum <= tmpSheet.getLastRowNum(); ++tmpRowNum) {
                    Row tmpRow = tmpSheet.getRow(tmpRowNum);
                    if (null == tmpRow) continue;
                    for (int tmpCellNum = 0; tmpCellNum <= tmpRow.getLastCellNum(); ++tmpCellNum) {
                        String tmpCellValue = ContentUtil.readCellContentAsString(tmpRow, tmpCellNum, tmpFormulaEvaluator, tmpLocale);
                        if (null == tmpCellValue) continue;
                        tmpResult.append(tmpCellValue);
                        tmpResult.append(" ");
                    }
                    if (tmpResult.length() > aMaxLength) {
                        String string = tmpResult.substring(0, aMaxLength) + MORE;
                        return string;
                    }
                    tmpResult.append(" ");
                }
                ++i;
            }
            return tmpResult.toString();
        }
        catch (IllegalArgumentException | POIXMLException e) {
            if (e.getCause() instanceof InvalidFormatException) {
                throw (InvalidFormatException)e.getCause();
            }
            InvalidFormatException tmpEx = new InvalidFormatException(e.getMessage());
            tmpEx.initCause(e);
            throw tmpEx;
        }
    }

    public static String readCellContentAsString(Row aRow, int aColumnNo, FormulaEvaluator aFormulaEvaluator, Locale aLocale) {
        Cell tmpCell = aRow.getCell(aColumnNo);
        if (null == tmpCell) {
            return null;
        }
        DataFormatter tmpDataFormatter = new DataFormatter(aLocale);
        try {
            return tmpDataFormatter.formatCellValue(tmpCell, aFormulaEvaluator);
        }
        catch (NotImplementedException e) {
            StringBuilder tmpMsg = new StringBuilder(e.getMessage());
            if (null != e.getCause()) {
                tmpMsg.append(" (").append(e.getCause().toString()).append(')');
            }
            LOG.error(tmpMsg.toString());
            return tmpDataFormatter.formatCellValue(tmpCell, null);
        }
    }

    public static String getZipContentAsString(InputStream anInputStream, Charset aCharset, Locale anExcelLocale, int aMaxLength) throws IOException {
        NormalizedString tmpResult = new NormalizedString();
        ZipInputStream tmpZipInput = new ZipInputStream(anInputStream);
        ZipEntry tmpZipEntry = tmpZipInput.getNextEntry();
        while (null != tmpZipEntry) {
            tmpResult.append("[");
            tmpResult.append(tmpZipEntry.getName());
            tmpResult.append("] ");
            IBrowser.ContentType tmpType = ContentTypeUtil.getContentTypeForFileName(tmpZipEntry.getName());
            if (IBrowser.ContentType.PDF == tmpType) {
                try {
                    tmpResult.append(ContentUtil.getPdfContentAsString(new CloseIgnoringInputStream(tmpZipInput), aMaxLength));
                }
                catch (IOException e) {
                    throw new IOException("Can't convert the zipped pdf '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
                }
            }
            if (IBrowser.ContentType.XLS == tmpType || IBrowser.ContentType.XLSX == tmpType) {
                try {
                    tmpResult.append(ContentUtil.getExcelContentAsString(new CloseIgnoringInputStream(tmpZipInput), anExcelLocale, aMaxLength));
                }
                catch (IOException | InvalidFormatException e) {
                    throw new IOException("Can't convert the zipped xls '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
                }
            }
            if (IBrowser.ContentType.DOC == tmpType || IBrowser.ContentType.DOCX == tmpType) {
                try {
                    tmpResult.append(ContentUtil.getWordContentAsString(new CloseIgnoringInputStream(tmpZipInput), aMaxLength));
                }
                catch (IOException | InvalidFormatException e) {
                    throw new IOException("Can't convert the zipped doc '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
                }
            }
            if (IBrowser.ContentType.RTF == tmpType) {
                try {
                    tmpResult.append(ContentUtil.getRtfContentAsString(new CloseIgnoringInputStream(tmpZipInput), aMaxLength));
                }
                catch (IOException | BadLocationException e) {
                    throw new IOException("Can't convert the zipped rtf '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
                }
            }
            try {
                tmpResult.append(ContentUtil.getTxtContentAsString(new CloseIgnoringInputStream(tmpZipInput), aCharset, aMaxLength));
            }
            catch (IOException e) {
                throw new IOException("Can't convert the zipped content '" + tmpZipEntry.getName() + "' into text (reason: " + e.toString() + ").");
            }
            if (null == (tmpZipEntry = tmpZipInput.getNextEntry())) continue;
            tmpResult.append(" ");
        }
        return tmpResult.toString();
    }

    public static boolean isTxt(String aText) {
        int tmpCharCount = 0;
        for (int i = 0; i < aText.length(); ++i) {
            char tmpChar = aText.charAt(i);
            if (!Character.isLetterOrDigit(tmpChar)) continue;
            ++tmpCharCount;
        }
        return (double)tmpCharCount * 1.0 / (double)aText.length() > 0.7;
    }

    public static Locale determineLocaleFromRequestHeader(String anAcceptLanguageHeader) {
        if (null == anAcceptLanguageHeader) {
            return null;
        }
        Iterator<String> tmpLanguages = StringUtil.extractStrings(anAcceptLanguageHeader, ",", -1).iterator();
        while (tmpLanguages.hasNext()) {
            List<String> tmpLanguageDescriptor = StringUtil.extractStrings(tmpLanguages.next(), ";", -1);
            if (tmpLanguageDescriptor.isEmpty()) {
                return null;
            }
            String tmpLocaleString = tmpLanguageDescriptor.get(0);
            List<String> tmpLocaleDescriptor = StringUtil.extractStrings(tmpLocaleString, "-", -1);
            if (tmpLocaleDescriptor.isEmpty()) break;
            String[] tmpISO639 = Locale.getISOLanguages();
            String tmpLanguage = tmpLocaleDescriptor.get(0).toLowerCase(Locale.ENGLISH);
            for (String tmpISO639Language : tmpISO639) {
                if (!tmpISO639Language.equals(tmpLanguage)) continue;
                String tmpCountry3166 = "";
                if (tmpLocaleDescriptor.size() > 1) {
                    String[] tmpISO3166;
                    String tmpCountry = tmpLocaleDescriptor.get(1).toUpperCase(Locale.ENGLISH);
                    for (String tmpISO3166Country : tmpISO3166 = Locale.getISOCountries()) {
                        if (!tmpISO3166Country.equals(tmpCountry)) continue;
                        tmpCountry3166 = tmpCountry;
                    }
                }
                return new Locale(tmpLanguage, tmpCountry3166);
            }
        }
        return null;
    }

    private ContentUtil() {
    }

    private static final class CloseIgnoringInputStream
    extends FilterInputStream {
        private CloseIgnoringInputStream(InputStream anInputStream) {
            super(anInputStream);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

