/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.scripter.xml;

import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wetator.exception.ImplementationException;
import org.wetator.scripter.ParseException;
import org.wetator.scripter.XMLScripter;
import org.wetator.scripter.xml.LocalEntityResolver;
import org.wetator.scripter.xml.XMLSchema;
import org.wetator.scripter.xml.model.CommandType;
import org.wetator.scripter.xml.model.ParameterType;
import org.wetator.util.NormalizedString;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModelBuilder {
    private static final String BASE_COMMAND_TYPE = "commandType";
    private static final String BASE_PARAMETER_TYPE = "parameterType";
    private XSSimpleType baseParameterType;
    private Map<String, CommandType> commandTypes = new LinkedHashMap<String, CommandType>();

    public ModelBuilder(List<XMLSchema> aSchemas, File aSchemaDirectory) throws IOException, SAXException, ParseException {
        XSSchemaSet tmpSchemaSet = this.parseSchemas(aSchemas, aSchemaDirectory);
        this.buildModel(tmpSchemaSet);
    }

    public CommandType getCommandType(String aName) {
        return this.commandTypes.get(aName);
    }

    public List<CommandType> getCommandTypes() {
        ArrayList<CommandType> tmpCommandTypes = new ArrayList<CommandType>(this.commandTypes.values());
        Collections.sort(tmpCommandTypes, new Comparator<CommandType>(){

            @Override
            public int compare(CommandType aType1, CommandType aType2) {
                return aType1.getName().compareToIgnoreCase(aType2.getName());
            }
        });
        return tmpCommandTypes;
    }

    private XSSchemaSet parseSchemas(List<XMLSchema> aSchemaList, File aSchemaDirectory) throws IOException, SAXException, ParseException {
        if (aSchemaList == null || aSchemaList.isEmpty()) {
            throw new ImplementationException("No schema to parse.");
        }
        LocalEntityResolver tmpEntityResolver = new LocalEntityResolver(aSchemaDirectory);
        XSOMParser tmpParser = new XSOMParser(SAXParserFactory.newInstance());
        tmpParser.setAnnotationParser((AnnotationParserFactory)new DomAnnotationParserFactory());
        tmpParser.setEntityResolver((EntityResolver)tmpEntityResolver);
        for (XMLSchema tmpSchema : aSchemaList) {
            InputSource tmpSource = tmpEntityResolver.resolveEntity(tmpSchema.getNamespace(), tmpSchema.getLocation());
            if (tmpSource != null) {
                tmpParser.parse(tmpSource);
                continue;
            }
            throw new ParseException("Could not resolve schema file '" + tmpSchema.getNamespace() + "'.");
        }
        return tmpParser.getResult();
    }

    private void buildModel(XSSchemaSet aSchemaSet) throws ParseException {
        XSSchema tmpBaseSchema = aSchemaSet.getSchema(XMLScripter.BASE_SCHEMA.getNamespace());
        if (tmpBaseSchema == null) {
            throw new ParseException("No base schema '" + XMLScripter.BASE_SCHEMA.getNamespace() + "' found.");
        }
        XSComplexType tmpBaseCommandType = tmpBaseSchema.getComplexType(BASE_COMMAND_TYPE);
        this.baseParameterType = tmpBaseSchema.getSimpleType(BASE_PARAMETER_TYPE);
        Iterator tmpIterator = aSchemaSet.iterateElementDecls();
        while (tmpIterator.hasNext()) {
            XSElementDecl tmpElement = (XSElementDecl)tmpIterator.next();
            if (!tmpElement.getType().isDerivedFrom((XSType)tmpBaseCommandType) || ((XSComplexType)tmpElement.getType()).isAbstract()) continue;
            String tmpElementName = tmpElement.getName();
            CommandType tmpExistingCommandType = this.commandTypes.get(tmpElementName);
            if (tmpExistingCommandType != null) {
                throw new ParseException("Duplicate command '" + tmpElementName + "' found ('" + tmpExistingCommandType.getNamespace() + "' and '" + tmpElement.getTargetNamespace() + "').");
            }
            CommandType tmpCommandType = new CommandType();
            tmpCommandType.setNamespace(tmpElement.getTargetNamespace());
            tmpCommandType.setName(tmpElementName);
            tmpCommandType.setDocumentation(this.getDocumentation(tmpElement));
            this.commandTypes.put(tmpElementName, tmpCommandType);
            XSComplexType tmpType = (XSComplexType)tmpElement.getType();
            for (ParameterType tmpParameterType : this.getParameterTypes(tmpType)) {
                String tmpParameterName = tmpParameterType.getName();
                for (ParameterType tmpCommandParameterType : tmpCommandType.getParameterTypes()) {
                    if (!tmpCommandParameterType.getName().equals(tmpParameterName)) continue;
                    throw new ParseException("Duplicate parameter '" + tmpElementName + "' found for command '" + tmpCommandType.getNamespace() + ":" + tmpCommandType.getName() + "'.");
                }
                tmpCommandType.getParameterTypes().add(tmpParameterType);
            }
        }
    }

    private List<ParameterType> getParameterTypes(XSComplexType aType) {
        XSTerm tmpXsTerm;
        ArrayList<ParameterType> tmpParameterTypes = new ArrayList<ParameterType>();
        XSContentType tmpXsContentType = aType.getContentType();
        XSParticle tmpXsParticle = tmpXsContentType.asParticle();
        if (tmpXsParticle != null && (tmpXsTerm = tmpXsParticle.getTerm()).isModelGroup()) {
            XSParticle[] tmpXsParticles;
            XSModelGroup tmpXsModelGroup = tmpXsTerm.asModelGroup();
            for (XSParticle tmpChildParticle : tmpXsParticles = tmpXsModelGroup.getChildren()) {
                XSElementDecl tmpChildElement;
                XSTerm tmpChildTerm = tmpChildParticle.getTerm();
                if (!tmpChildTerm.isElementDecl() || !(tmpChildElement = tmpChildTerm.asElementDecl()).getType().isDerivedFrom((XSType)this.baseParameterType)) continue;
                ParameterType tmpParameter = new ParameterType();
                tmpParameter.setNamespace(tmpChildElement.getTargetNamespace());
                tmpParameter.setName(tmpChildElement.getName());
                tmpParameter.setDocumentation(this.getDocumentation(tmpChildElement));
                if (tmpChildParticle.getMinOccurs() != null && tmpChildParticle.getMinOccurs().intValue() == 0) {
                    tmpParameter.setOptional(true);
                }
                tmpParameterTypes.add(tmpParameter);
            }
        }
        return tmpParameterTypes;
    }

    private String getDocumentation(XSElementDecl anElement) {
        NormalizedString tmpDocumentation = new NormalizedString();
        if (anElement.getAnnotation() != null && anElement.getAnnotation().getAnnotation() != null) {
            Element tmpAnnotation = (Element)anElement.getAnnotation().getAnnotation();
            NodeList tmpDocumentationNodes = tmpAnnotation.getElementsByTagName("xs:documentation");
            for (int i = 0; i < tmpDocumentationNodes.getLength(); ++i) {
                String tmpText;
                Node tmpDocumentationNode = tmpDocumentationNodes.item(i);
                if (tmpDocumentationNode == null || (tmpText = tmpDocumentationNode.getTextContent()) == null || "".equals(tmpText.trim())) continue;
                if (tmpDocumentation.length() != 0) {
                    tmpDocumentation.append("\n");
                }
                tmpDocumentation.append(tmpText);
            }
        }
        return tmpDocumentation.toString();
    }
}

